/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.EnvironmentVariable;
import software.amazon.smithy.cli.Style;

public enum AnsiColorFormatter implements ColorFormatter
{
    NO_COLOR{

        @Override
        public String style(String text, Style ... styles) {
            return text;
        }

        @Override
        public void style(Appendable appendable, String text, Style ... styles) {
            try {
                appendable.append(text);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
    ,
    FORCE_COLOR{

        @Override
        public String style(String text, Style ... styles) {
            StringBuilder builder = new StringBuilder();
            this.style(builder, text, styles);
            return builder.toString();
        }

        @Override
        public void style(Appendable appendable, String text, Style ... styles) {
            try {
                if (styles.length == 0) {
                    appendable.append(text);
                } else {
                    appendable.append("\u001b[");
                    boolean isAfterFirst = false;
                    for (Style style : styles) {
                        if (isAfterFirst) {
                            appendable.append(';');
                        }
                        appendable.append(style.getAnsiColorCode());
                        isAfterFirst = true;
                    }
                    appendable.append('m');
                    appendable.append(text);
                    appendable.append("\u001b[0m");
                }
            }
            catch (IOException e) {
                throw new CliError("Error writing output", 2, e);
            }
        }
    }
    ,
    AUTO{
        private final AnsiColorFormatter delegate = AnsiColorFormatter.detect();

        @Override
        public String style(String text, Style ... styles) {
            return this.delegate.style(text, styles);
        }

        @Override
        public void style(Appendable appendable, String text, Style ... styles) {
            this.delegate.style(appendable, text, styles);
        }
    };


    public static AnsiColorFormatter detect() {
        return AnsiColorFormatter.isAnsiEnabled() ? FORCE_COLOR : NO_COLOR;
    }

    private static boolean isAnsiEnabled() {
        if (EnvironmentVariable.FORCE_COLOR.isSet()) {
            return true;
        }
        if (EnvironmentVariable.NO_COLOR.isSet()) {
            return false;
        }
        String term = EnvironmentVariable.TERM.get();
        if (Objects.equals(term, "dumb")) {
            return false;
        }
        if (term == null && System.getProperty("os.name").contains("win")) {
            return false;
        }
        return System.console() != null;
    }
}

