/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.shaded.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.cli.shaded.eclipse.aether.RequestTrace;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.DependencyNode;
import software.amazon.smithy.cli.shaded.eclipse.aether.graph.DependencyVisitor;
import software.amazon.smithy.cli.shaded.eclipse.aether.resolution.ArtifactRequest;

class ArtifactRequestBuilder
implements DependencyVisitor {
    private final RequestTrace trace;
    private final List<ArtifactRequest> requests;

    ArtifactRequestBuilder(RequestTrace trace) {
        this.trace = trace;
        this.requests = new ArrayList<ArtifactRequest>();
    }

    public List<ArtifactRequest> getRequests() {
        return this.requests;
    }

    @Override
    public boolean visitEnter(DependencyNode node) {
        if (node.getDependency() != null) {
            ArtifactRequest request = new ArtifactRequest(node);
            request.setTrace(this.trace);
            this.requests.add(request);
        }
        return true;
    }

    @Override
    public boolean visitLeave(DependencyNode node) {
        return true;
    }
}

