/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.ColorFormatter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.EnvironmentVariable;
import software.amazon.smithy.cli.SmithyCli;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.cli.commands.AstCommand;
import software.amazon.smithy.cli.commands.BuildCommand;
import software.amazon.smithy.cli.commands.CleanCommand;
import software.amazon.smithy.cli.commands.DiffCommand;
import software.amazon.smithy.cli.commands.SelectCommand;
import software.amazon.smithy.cli.commands.Upgrade1to2Command;
import software.amazon.smithy.cli.commands.ValidateCommand;
import software.amazon.smithy.cli.commands.WarmupCommand;
import software.amazon.smithy.cli.dependencies.DependencyResolver;

public final class SmithyCommand
implements Command {
    private final List<Command> commands;

    public SmithyCommand(DependencyResolver.Factory dependencyResolverFactory) {
        Objects.requireNonNull(dependencyResolverFactory);
        this.commands = Arrays.asList(new ValidateCommand(this.getName(), dependencyResolverFactory), new BuildCommand(this.getName(), dependencyResolverFactory), new DiffCommand(this.getName(), dependencyResolverFactory), new AstCommand(this.getName(), dependencyResolverFactory), new SelectCommand(this.getName(), dependencyResolverFactory), new CleanCommand(this.getName()), new Upgrade1to2Command(this.getName()), new WarmupCommand(this.getName(), dependencyResolverFactory));
    }

    @Override
    public String getName() {
        return "smithy";
    }

    @Override
    public String getSummary() {
        return "";
    }

    @Override
    public void printHelp(Arguments arguments, ColorFormatter colors, CliPrinter printer) {
        printer.println(String.format("Usage: %s [-h | --help] [--version] <command> [<args>]", colors.style("smithy", Style.BRIGHT_WHITE, Style.UNDERLINE)));
        printer.println("");
        printer.println("Available commands:");
        int longestName = 0;
        for (Command command : this.commands) {
            if (command.isHidden() || command.getName().length() + 12 <= longestName) continue;
            longestName = command.getName().length() + 12;
        }
        for (Command command : this.commands) {
            if (command.isHidden()) continue;
            printer.println(String.format("    %-" + longestName + "s %s", colors.style(command.getName(), Style.YELLOW), command.getSummary()));
        }
        printer.println("");
    }

    @Override
    public int execute(Arguments arguments, Command.Env env) {
        EnvironmentVariable.SMITHY_VERSION.set(SmithyCli.getVersion());
        String command = arguments.shift();
        if (command == null) {
            arguments.finishParsing();
            StandardOptions standardOptions = arguments.getReceiver(StandardOptions.class);
            if (standardOptions.help()) {
                this.printHelp(arguments, env.colors(), env.stdout());
                return 0;
            }
            if (standardOptions.version()) {
                env.stdout().println(SmithyCli.getVersion());
                return 0;
            }
            this.printHelp(arguments, env.colors(), env.stderr());
            return 1;
        }
        for (Command c : this.commands) {
            if (!c.getName().equals(command)) continue;
            return c.execute(arguments, env);
        }
        throw new CliError("Unknown argument or command: " + command);
    }
}

