/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
abstract class SimpleCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(SimpleCommand.class.getName());
    private final String parentCommandName;

    SimpleCommand(String parentCommandName) {
        this.parentCommandName = parentCommandName;
    }

    @Override
    public final int execute(Arguments arguments, Command.Env env) {
        List<ArgumentReceiver> receivers = this.createArgumentReceivers();
        for (ArgumentReceiver receiver : receivers) {
            arguments.addReceiver(receiver);
        }
        List<String> positionalArguments = arguments.finishParsing();
        if (arguments.getReceiver(StandardOptions.class).help()) {
            this.printHelp(arguments, env.stdout());
            return 0;
        }
        LOGGER.fine(() -> "Invoking Command with positional arguments: " + positionalArguments);
        return this.run(arguments, env, positionalArguments);
    }

    @Override
    public void printHelp(Arguments arguments, CliPrinter printer) {
        String name = StringUtils.isEmpty((CharSequence)this.parentCommandName) ? this.getName() : this.parentCommandName + " " + this.getName();
        HelpPrinter.fromArguments(name, arguments).summary(this.getSummary()).documentation(this.getDocumentation(printer)).print(printer);
    }

    protected abstract List<ArgumentReceiver> createArgumentReceivers();

    protected abstract int run(Arguments var1, Command.Env var2, List<String> var3);
}

