/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.Arrays;
import java.util.logging.Logger;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.LoggingUtil;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class Cli {
    private static final Logger LOGGER = Logger.getLogger(Cli.class.getName());
    private static final boolean ANSI_SUPPORTED = Cli.isAnsiColorSupported();
    private CliPrinter stdoutPrinter = new CliPrinter.ConsumerPrinter(str -> System.out.print(str));
    private CliPrinter stdErrPrinter = new CliPrinter.ConsumerPrinter(str -> System.err.print(str));
    private final ClassLoader classLoader;
    private final Command command;

    public Cli(Command command, ClassLoader classLoader) {
        this.command = command;
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args) {
        int n;
        Arguments arguments = new Arguments(args);
        StandardOptions standardOptions = new StandardOptions();
        arguments.addReceiver(standardOptions);
        CliPrinter out = Cli.ansiPrinter(this.stdoutPrinter, standardOptions);
        CliPrinter err = Cli.ansiPrinter(this.stdErrPrinter, standardOptions);
        arguments.onComplete((opts, positional) -> {
            LoggingUtil.configureLogging(opts.getReceiver(StandardOptions.class), err);
            LOGGER.fine(() -> "Running CLI command: " + Arrays.toString(args));
        });
        try {
            n = this.command.execute(arguments, new Command.Env(out, err, this.classLoader));
        }
        catch (Exception e) {
            try {
                this.printException(standardOptions.stackTrace(), err, e);
                throw CliError.wrap(e);
            }
            catch (Throwable throwable) {
                try {
                    LoggingUtil.restoreLogging();
                    throw throwable;
                }
                catch (RuntimeException e2) {
                    err.println(err.style("Unable to restore logging to previous settings", Style.RED));
                    this.printException(true, err, e2);
                }
                throw throwable;
            }
        }
        try {
            LoggingUtil.restoreLogging();
            return n;
        }
        catch (RuntimeException e) {
            err.println(err.style("Unable to restore logging to previous settings", Style.RED));
            this.printException(true, err, e);
        }
        return n;
    }

    public void stdout(CliPrinter printer) {
        this.stdoutPrinter = printer;
    }

    public void stderr(CliPrinter printer) {
        this.stdErrPrinter = printer;
    }

    private static boolean isAnsiColorSupported() {
        return System.console() != null && System.getenv().get("TERM") != null;
    }

    private void printException(boolean stacktrace, CliPrinter printer, Throwable throwable) {
        if (throwable instanceof NullPointerException) {
            printer.println(this.stdErrPrinter.style("A null pointer exception occurred while running the Smithy CLI. The --stacktrace argument can be used to get more information. Please open an issue with the Smithy team on GitHub so this can be investigated: https://github.com/awslabs/smithy/issues", Style.RED));
        }
        printer.println(printer.style(throwable.getMessage(), Style.RED, Style.BOLD));
        if (stacktrace) {
            printer.println(printer.style(throwable.getClass().getCanonicalName() + ":", Style.RED, Style.UNDERLINE));
            for (StackTraceElement element : throwable.getStackTrace()) {
                printer.println("\tat " + element.toString());
            }
        }
    }

    private static CliPrinter ansiPrinter(final CliPrinter delegate, final StandardOptions options) {
        return new CliPrinter(){

            @Override
            public void println(String text) {
                delegate.println(text);
            }

            @Override
            public String style(String text, Style ... styles) {
                if (options.forceColor() || !options.noColor() && ANSI_SUPPORTED) {
                    return delegate.style(text, styles);
                }
                return text;
            }
        };
    }
}

