/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.SimpleCommand;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ValidateCommand
extends SimpleCommand {
    private static final Logger LOGGER = Logger.getLogger(ValidateCommand.class.getName());

    public ValidateCommand(String parentCommandName) {
        super(parentCommandName);
    }

    @Override
    public String getName() {
        return "validate";
    }

    @Override
    public String getSummary() {
        return "Validates Smithy models";
    }

    @Override
    protected List<ArgumentReceiver> createArgumentReceivers() {
        return Collections.singletonList(new BuildOptions());
    }

    @Override
    protected int run(Arguments arguments, Command.Env env, List<String> models) {
        StandardOptions standardOptions = arguments.getReceiver(StandardOptions.class);
        LOGGER.info(() -> "Validating Smithy model sources: " + models);
        CommandUtils.buildModel(arguments, models, env, env.stdout(), standardOptions.quiet());
        LOGGER.info("Smithy validation complete");
        return 0;
    }
}

