/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.SimpleCommand;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class SelectCommand
extends SimpleCommand {
    public SelectCommand(String parentCommandName) {
        super(parentCommandName);
    }

    @Override
    public String getName() {
        return "select";
    }

    @Override
    public String getSummary() {
        return "Queries a model using a selector";
    }

    @Override
    public String getDocumentation(CliPrinter printer) {
        return "By default, each matching shape ID is printed to stdout on a new line. Pass --vars to print out a JSON array that contains a 'shape' and 'vars' property, where the 'vars' property is a map of each variable that was captured when the shape was matched.";
    }

    @Override
    protected List<ArgumentReceiver> createArgumentReceivers() {
        return ListUtils.of((Object)new BuildOptions(), (Object)new Options());
    }

    @Override
    protected int run(Arguments arguments, Command.Env env, List<String> models) {
        CliPrinter stdout = env.stdout();
        Options options = arguments.getReceiver(Options.class);
        Model model = CommandUtils.buildModel(arguments, models, env, env.stderr(), true);
        Selector selector = options.selector();
        if (!options.vars()) {
            this.sortShapeIds(selector.select(model)).forEach(stdout::println);
        } else {
            ArrayList result = new ArrayList();
            selector.consumeMatches(model, match -> result.add(Node.objectNodeBuilder().withMember("shape", (ToNode)Node.from((String)match.getShape().getId().toString())).withMember("vars", (ToNode)this.collectVars((Map<String, Set<Shape>>)match)).build()));
            stdout.println(Node.prettyPrintJson((Node)new ArrayNode(result, SourceLocation.NONE)));
        }
        return 0;
    }

    private Stream<String> sortShapeIds(Collection<Shape> shapes) {
        return shapes.stream().map(Shape::getId).map(ShapeId::toString).sorted();
    }

    private ObjectNode collectVars(Map<String, Set<Shape>> vars) {
        ObjectNode.Builder varBuilder = Node.objectNodeBuilder();
        for (Map.Entry<String, Set<Shape>> varEntry : vars.entrySet()) {
            ArrayNode value = (ArrayNode)this.sortShapeIds((Collection<Shape>)varEntry.getValue()).map(Node::from).collect(ArrayNode.collect());
            varBuilder.withMember(varEntry.getKey(), (ToNode)value);
        }
        return varBuilder.build();
    }

    private static final class Options
    implements ArgumentReceiver {
        private boolean vars;
        private Selector selector;

        private Options() {
        }

        @Override
        public boolean testOption(String name) {
            if (name.equals("--vars")) {
                this.vars = true;
                return true;
            }
            return false;
        }

        @Override
        public Consumer<String> testParameter(String name) {
            if (name.equals("--selector")) {
                return value -> {
                    this.selector = Selector.parse((String)value);
                };
            }
            return null;
        }

        @Override
        public void registerHelp(HelpPrinter printer) {
            printer.option("--vars", null, "Include the variables that were captured when the shape was matched. The output of the command is JSON when --vars is passed.");
            printer.param("--selector", null, "SELECTOR", "The Smithy selector to execute. Reads from STDIN when not provided.");
        }

        public boolean vars() {
            return this.vars;
        }

        public Selector selector() {
            if (this.selector == null) {
                this.selector = Selector.parse((String)IoUtils.toUtf8String((InputStream)System.in));
            }
            return this.selector;
        }
    }
}

