/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.function.Consumer;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class BuildOptions
implements ArgumentReceiver {
    public static final String ALLOW_UNKNOWN_TRAITS = "--allow-unknown-traits";
    public static final String DISCOVER = "--discover";
    public static final String DISCOVER_SHORT = "-d";
    public static final String DISCOVER_CLASSPATH = "--discover-classpath";
    public static final String MODELS = "<MODELS>";
    private String discoverClasspath;
    private boolean allowUnknownTraits;
    private boolean discover;

    @Override
    public void registerHelp(HelpPrinter printer) {
        printer.option(ALLOW_UNKNOWN_TRAITS, null, "Ignores unknown traits when validating models");
        printer.option(DISCOVER, DISCOVER_SHORT, "Enables model discovery, merging in models found inside of jars");
        printer.param(DISCOVER_CLASSPATH, null, "CLASSPATH", "Enables model discovery using a custom classpath for models");
        printer.positional(MODELS, "Model files and directories to load");
    }

    @Override
    public boolean testOption(String name) {
        switch (name) {
            case "--allow-unknown-traits": {
                this.allowUnknownTraits = true;
                return true;
            }
            case "--discover": 
            case "-d": {
                this.discover = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public Consumer<String> testParameter(String name) {
        if (DISCOVER_CLASSPATH.equals(name)) {
            return value -> {
                this.discoverClasspath = value;
            };
        }
        return null;
    }

    public String discoverClasspath() {
        return this.discoverClasspath;
    }

    public boolean allowUnknownTraits() {
        return this.allowUnknownTraits;
    }

    public boolean discover() {
        return this.discover;
    }
}

