/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.ProjectionResult;
import software.amazon.smithy.build.SmithyBuild;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.ArgumentReceiver;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.HelpPrinter;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.cli.commands.BuildOptions;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.SimpleCommand;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class BuildCommand
extends SimpleCommand {
    private static final Logger LOGGER = Logger.getLogger(BuildCommand.class.getName());

    public BuildCommand(String parentCommandName) {
        super(parentCommandName);
    }

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public String getSummary() {
        return "Builds Smithy models and creates plugin artifacts for each projection found in smithy-build.json.";
    }

    @Override
    protected List<ArgumentReceiver> createArgumentReceivers() {
        return ListUtils.of((Object)new BuildOptions(), (Object)new Options());
    }

    @Override
    protected int run(Arguments arguments, Command.Env env, List<String> models) {
        Options options = arguments.getReceiver(Options.class);
        StandardOptions standardOptions = arguments.getReceiver(StandardOptions.class);
        String output = options.output;
        LOGGER.fine(() -> String.format("Building Smithy model sources: %s", models));
        SmithyBuildConfig.Builder configBuilder = SmithyBuildConfig.builder();
        List<String> config = this.getConfig(options);
        if (!config.isEmpty()) {
            LOGGER.fine(() -> String.format("Loading Smithy configs: [%s]", String.join((CharSequence)" ", config)));
            config.forEach(file -> configBuilder.load(Paths.get(file, new String[0])));
        } else {
            configBuilder.version("1.0");
        }
        if (output != null) {
            configBuilder.outputDirectory(output);
            try {
                Files.createDirectories(Paths.get(output, new String[0]), new FileAttribute[0]);
                LOGGER.info(() -> "Output directory set to: " + output);
            }
            catch (IOException e) {
                throw new CliError("Unable to create Smithy output directory: " + e.getMessage());
            }
        }
        SmithyBuildConfig smithyBuildConfig = configBuilder.build();
        Model model = CommandUtils.buildModel(arguments, models, env, env.stderr(), standardOptions.quiet());
        SmithyBuild smithyBuild = SmithyBuild.create((ClassLoader)env.classLoader()).config(smithyBuildConfig).model(model);
        if (options.plugin != null) {
            smithyBuild.pluginFilter(name -> name.equals(options.plugin));
        }
        if (options.projection != null) {
            smithyBuild.projectionFilter(name -> name.equals(options.projection));
        }
        models.forEach(path -> smithyBuild.registerSources(new Path[]{Paths.get(path, new String[0])}));
        ResultConsumer resultConsumer = new ResultConsumer(env.stderr(), standardOptions.quiet());
        smithyBuild.build((Consumer)resultConsumer, (BiConsumer)resultConsumer);
        if (!standardOptions.quiet()) {
            Style ansiColor = resultConsumer.failedProjections.isEmpty() ? Style.BRIGHT_GREEN : Style.BRIGHT_YELLOW;
            env.stderr().println(env.stderr().style(String.format("Smithy built %s projection(s), %s plugin(s), and %s artifacts", resultConsumer.projectionCount, resultConsumer.pluginCount, resultConsumer.artifactCount), Style.BOLD, ansiColor));
        }
        if (!resultConsumer.failedProjections.isEmpty()) {
            resultConsumer.failedProjections.sort(String::compareTo);
            throw new CliError(String.format("The following %d Smithy build projection(s) failed: %s", resultConsumer.failedProjections.size(), resultConsumer.failedProjections));
        }
        return 0;
    }

    private List<String> getConfig(Options options) {
        List<String> config = options.config;
        if (config.isEmpty() && Files.exists(Paths.get("smithy-build.json", new String[0]), new LinkOption[0])) {
            config = Collections.singletonList("smithy-build.json");
        }
        return config;
    }

    private static final class ResultConsumer
    implements Consumer<ProjectionResult>,
    BiConsumer<String, Throwable> {
        private final List<String> failedProjections = Collections.synchronizedList(new ArrayList());
        private final AtomicInteger artifactCount = new AtomicInteger();
        private final AtomicInteger pluginCount = new AtomicInteger();
        private final AtomicInteger projectionCount = new AtomicInteger();
        private final boolean quiet;
        private final CliPrinter printer;

        ResultConsumer(CliPrinter stderr, boolean quiet) {
            this.printer = stderr;
            this.quiet = quiet;
        }

        @Override
        public void accept(String name, Throwable exception) {
            this.failedProjections.add(name);
            StringBuilder message = new StringBuilder(String.format("%nProjection %s failed: %s%n", name, exception.toString()));
            for (StackTraceElement element : exception.getStackTrace()) {
                message.append(element).append(System.lineSeparator());
            }
            this.printer.println(this.printer.style(message.toString(), Style.RED));
        }

        @Override
        public void accept(ProjectionResult result) {
            Path root;
            if (result.isBroken()) {
                this.failedProjections.add(result.getProjectionName());
                StringBuilder message = new StringBuilder(System.lineSeparator());
                message.append(result.getProjectionName()).append(" has a model that failed validation").append(System.lineSeparator());
                result.getEvents().forEach(event -> {
                    if (event.getSeverity() == Severity.DANGER || event.getSeverity() == Severity.ERROR) {
                        message.append(event).append(System.lineSeparator());
                    }
                });
                this.printer.println(this.printer.style(message.toString(), Style.RED));
            } else {
                this.projectionCount.incrementAndGet();
            }
            this.pluginCount.addAndGet(result.getPluginManifests().size());
            Iterator manifestIterator = result.getPluginManifests().values().iterator();
            Path path = root = manifestIterator.hasNext() ? ((FileManifest)manifestIterator.next()).getBaseDir().getParent() : null;
            if (!this.quiet) {
                String message = String.format("Completed projection %s (%d shapes): %s", result.getProjectionName(), result.getModel().toSet().size(), root);
                this.printer.println(this.printer.style(message, Style.GREEN));
            }
            for (FileManifest manifest : result.getPluginManifests().values()) {
                this.artifactCount.addAndGet(manifest.getFiles().size());
            }
        }
    }

    private static final class Options
    implements ArgumentReceiver {
        private final List<String> config = new ArrayList<String>();
        private String output;
        private String projection;
        private String plugin;

        private Options() {
        }

        @Override
        public boolean testOption(String name) {
            return false;
        }

        @Override
        public Consumer<String> testParameter(String name) {
            switch (name) {
                case "--config": 
                case "-c": {
                    return this.config::add;
                }
                case "--output": {
                    return value -> {
                        this.output = value;
                    };
                }
                case "--projection": {
                    return value -> {
                        this.projection = value;
                    };
                }
                case "--plugin": {
                    return value -> {
                        this.plugin = value;
                    };
                }
            }
            return null;
        }

        @Override
        public void registerHelp(HelpPrinter printer) {
            printer.param("--config", "-c", "CONFIG_PATH...", "Path to smithy-build.json configuration (defaults to './smithy-build.json'). This option can be repeated and each configured will be merged.");
            printer.param("--projection", null, "PROJECTION_NAME", "Only generate artifacts for this projection.");
            printer.param("--plugin", null, "PLUGIN_NAME", "Only generate artifacts for this plugin.");
            printer.param("--output", null, "OUTPUT_PATH", "Where to write artifacts (defaults to './build/smithy').");
        }
    }
}

