/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.Arrays;
import java.util.List;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.CliPrinter;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.StandardOptions;
import software.amazon.smithy.cli.Style;
import software.amazon.smithy.cli.commands.AstCommand;
import software.amazon.smithy.cli.commands.BuildCommand;
import software.amazon.smithy.cli.commands.DiffCommand;
import software.amazon.smithy.cli.commands.SelectCommand;
import software.amazon.smithy.cli.commands.Upgrade1to2Command;
import software.amazon.smithy.cli.commands.ValidateCommand;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class SmithyCommand
implements Command {
    private final List<Command> commands = Arrays.asList(new ValidateCommand(this.getName()), new BuildCommand(this.getName()), new AstCommand(this.getName()), new SelectCommand(this.getName()), new DiffCommand(this.getName()), new Upgrade1to2Command(this.getName()));

    @Override
    public String getName() {
        return "smithy";
    }

    @Override
    public String getSummary() {
        return "";
    }

    @Override
    public void printHelp(Arguments arguments, CliPrinter printer) {
        printer.println(String.format("Usage: %s [-h | --help] <command> [<args>]", printer.style("smithy", Style.BRIGHT_WHITE, Style.UNDERLINE)));
        printer.println("");
        printer.println("Available commands:");
        int longestName = 0;
        for (Command command : this.commands) {
            if (command.getName().length() + 12 <= longestName) continue;
            longestName = command.getName().length() + 12;
        }
        for (Command command : this.commands) {
            printer.println(String.format("    %-" + longestName + "s %s", printer.style(command.getName(), Style.YELLOW), command.getSummary()));
        }
    }

    @Override
    public int execute(Arguments arguments, Command.Env env) {
        String command = arguments.shift();
        if (command == null) {
            arguments.finishParsing();
            if (arguments.getReceiver(StandardOptions.class).help()) {
                this.printHelp(arguments, env.stdout());
                return 0;
            }
            this.printHelp(arguments, env.stderr());
            return 1;
        }
        for (Command c : this.commands) {
            if (!c.getName().equals(command)) continue;
            return c.execute(arguments, env);
        }
        throw new CliError("Unknown argument or command: " + command);
    }
}

