/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.Cli;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Parser;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.Validator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ModelSerializer;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class AstCommand
implements Command {
    @Override
    public String getName() {
        return "ast";
    }

    @Override
    public String getSummary() {
        return "Reads Smithy models in and writes out a single JSON AST model";
    }

    @Override
    public Parser getParser() {
        return Parser.builder().option("--allow-unknown-traits", "Ignores unknown traits when validating models").option("--discover", "-d", "Enables model discovery, merging in models found inside of jars").parameter("--discover-classpath", "Enables model discovery using a custom classpath for models").positional("<MODELS>", "Path to Smithy models or directories").build();
    }

    @Override
    public void execute(Arguments arguments, ClassLoader classLoader) {
        Model model = CommandUtils.buildModel(arguments, classLoader, SetUtils.of((Object)((Object)Validator.Feature.QUIET)));
        ModelSerializer serializer = ModelSerializer.builder().build();
        Cli.stdout(Node.prettyPrintJson((Node)serializer.serialize(model)));
    }
}

