/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class Arguments {
    private final Map<String, List<String>> arguments;
    private final List<String> positionalArguments;

    public Arguments(Map<String, List<String>> arguments, List<String> positionalArguments) {
        this.arguments = Collections.unmodifiableMap(arguments);
        this.positionalArguments = Collections.unmodifiableList(positionalArguments);
    }

    public boolean has(String arg) {
        return this.arguments.containsKey(arg);
    }

    public String parameter(String arg) {
        return this.repeatedParameter(arg).get(0);
    }

    public String parameter(String arg, String defaultValue) {
        List<String> values = this.arguments.get(arg);
        return values == null || values.isEmpty() ? defaultValue : values.get(0);
    }

    public List<String> repeatedParameter(String arg) {
        if (this.arguments.containsKey(arg)) {
            List<String> argVal = this.arguments.get(arg);
            if (argVal == null || argVal.isEmpty()) {
                throw new CliError("Argument " + arg + " was provided no value");
            }
            return argVal;
        }
        throw new CliError("Missing required argument: " + arg);
    }

    public List<String> repeatedParameter(String arg, List<String> defaultValues) {
        List<String> values = this.arguments.get(arg);
        return values == null || values.isEmpty() ? defaultValues : values;
    }

    public List<String> positionalArguments() {
        return this.positionalArguments;
    }

    public String toString() {
        return "Arguments{arguments=" + this.arguments + ", positionalArguments=" + this.positionalArguments + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Arguments)) {
            return false;
        }
        Arguments other = (Arguments)o;
        return this.arguments.equals(other.arguments) && this.positionalArguments.equals(other.positionalArguments);
    }

    public int hashCode() {
        return Objects.hash(this.arguments, this.positionalArguments);
    }
}

