/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import software.amazon.smithy.cli.Cli;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.ContextualValidationEventFormatter;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;

final class Validator {
    private Validator() {
    }

    static void validate(ValidatedResult<Model> result) {
        ContextualValidationEventFormatter formatter = new ContextualValidationEventFormatter();
        result.getValidationEvents().stream().filter(event -> event.getSeverity() != Severity.SUPPRESSED).sorted().forEach(event -> {
            if (event.getSeverity() == Severity.WARNING) {
                Colors.YELLOW.out(formatter.format(event));
            } else if (event.getSeverity() == Severity.DANGER || event.getSeverity() == Severity.ERROR) {
                Colors.RED.out(formatter.format(event));
            } else {
                Cli.stdout(event);
            }
            Cli.stdout("");
        });
        long errors = result.getValidationEvents(Severity.ERROR).size();
        long dangers = result.getValidationEvents(Severity.DANGER).size();
        String line = String.format("Validation result: %s ERROR(s), %d DANGER(s), %d WARNING(s), %d NOTE(s)", errors, dangers, result.getValidationEvents(Severity.WARNING).size(), result.getValidationEvents(Severity.NOTE).size());
        Cli.stdout(line);
        result.getResult().ifPresent(model -> Cli.stdout(String.format("Validated %d shapes in model", model.shapes().count())));
        if (!result.getResult().isPresent() || errors + dangers > 0L) {
            throw new CliError(String.format("The model is invalid: %s ERROR(s), %d DANGER(s)", errors, dangers));
        }
    }
}

