/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.util.List;
import software.amazon.smithy.cli.Cli;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.commands.BuildCommand;
import software.amazon.smithy.cli.commands.DiffCommand;
import software.amazon.smithy.cli.commands.ValidateCommand;

public final class SmithyCli {
    public static final String DISCOVER = "--discover";
    public static final String DISCOVER_CLASSPATH = "--discover-classpath";
    public static final String ALLOW_UNKNOWN_TRAITS = "--allow-unknown-traits";
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private boolean configureLogging;

    private SmithyCli() {
    }

    public static SmithyCli create() {
        return new SmithyCli();
    }

    public static void main(String ... args) {
        try {
            SmithyCli.create().configureLogging(true).run(args);
        }
        catch (CliError e) {
            System.exit(e.code);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public SmithyCli classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SmithyCli configureLogging(boolean configureLogging) {
        this.configureLogging = configureLogging;
        return this;
    }

    public void run(List<String> args) {
        this.run(args.toArray(new String[0]));
    }

    public void run(String ... args) {
        Cli cli = new Cli("smithy", this.classLoader);
        cli.configureLogging(this.configureLogging);
        cli.addCommand(new ValidateCommand());
        cli.addCommand(new BuildCommand());
        cli.addCommand(new DiffCommand());
        cli.run(args);
    }
}

