/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Parser;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.diff.ModelDiff;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class DiffCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(DiffCommand.class.getName());

    @Override
    public String getName() {
        return "diff";
    }

    @Override
    public String getSummary() {
        return "Diffs two Smithy models and reports any significant changes";
    }

    @Override
    public Parser getParser() {
        return Parser.builder().repeatedParameter("--old", "Path to an old Smithy model or directory that contains models").repeatedParameter("--new", "Path to the new Smithy model or directory that contains models").build();
    }

    @Override
    public void execute(Arguments arguments, ClassLoader classLoader) {
        List<String> oldModels = arguments.repeatedParameter("--old");
        LOGGER.info(String.format("Setting 'old' Smithy models: %s", String.join((CharSequence)" ", oldModels)));
        List<String> newModels = arguments.repeatedParameter("--new");
        LOGGER.info(String.format("Setting 'new' Smithy models: %s", String.join((CharSequence)" ", newModels)));
        ModelAssembler assembler = CommandUtils.createModelAssembler(classLoader);
        Model oldModel = this.loadModel("old", assembler, oldModels);
        assembler.reset();
        Model newModel = this.loadModel("new", assembler, newModels);
        List events = ModelDiff.compare((ClassLoader)classLoader, (Model)oldModel, (Model)newModel);
        boolean hasError = events.stream().anyMatch(event -> event.getSeverity() == Severity.ERROR);
        boolean hasDanger = events.stream().anyMatch(event -> event.getSeverity() == Severity.DANGER);
        boolean hasWarning = events.stream().anyMatch(event -> event.getSeverity() == Severity.DANGER);
        String result = events.stream().map(ValidationEvent::toString).collect(Collectors.joining("\n"));
        if (hasError) {
            throw new CliError(String.format("Model diff detected errors: %n%s", result));
        }
        if (!result.isEmpty()) {
            System.out.println(result);
        }
        if (hasDanger) {
            Colors.out(Colors.BRIGHT_BOLD_RED, "Smithy diff detected danger");
        } else if (hasWarning) {
            Colors.out(Colors.BRIGHT_BOLD_YELLOW, "Smithy diff complete with warnings");
        } else {
            Colors.out(Colors.BRIGHT_BOLD_GREEN, "Smithy diff complete");
        }
    }

    private Model loadModel(String descriptor, ModelAssembler assembler, List<String> models) {
        models.forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        ValidatedResult result = assembler.assemble();
        if (result.isBroken()) {
            throw new CliError("Error loading " + descriptor + " models: \n" + result.getValidationEvents().stream().map(ValidationEvent::toString).collect(Collectors.joining("\n")));
        }
        return (Model)result.unwrap();
    }
}

