/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli.commands;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.smithy.build.SmithyBuild;
import software.amazon.smithy.build.SmithyBuildResult;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Parser;
import software.amazon.smithy.cli.commands.CommandUtils;
import software.amazon.smithy.cli.commands.Validator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.validation.ValidatedResult;

public final class BuildCommand
implements Command {
    private static final Logger LOGGER = Logger.getLogger(BuildCommand.class.getName());

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public String getSummary() {
        return "Builds Smithy models and creates plugin artifacts for each projection";
    }

    @Override
    public Parser getParser() {
        return Parser.builder().repeatedParameter("--config", "-c", "Path to smithy-build.json configuration. Defaults to 'smithy-build.json'.").parameter("--output", "-o", "Where to write artifacts. Defaults to 'build/smithy'.").parameter("--projection", "Smithy will only generate artifacts for the given projection name.").parameter("--plugin", "Smithy will only generate artifacts for the given plugin name.").option("--discover", "-d", "Enables model discovery, merging in models found inside of jars").parameter("--discover-classpath", "Enables model discovery using a custom classpath for models").option("--allow-unknown-traits", "Ignores unknown traits when building models").positional("<MODELS>", "Path to Smithy models or directories").build();
    }

    @Override
    public void execute(Arguments arguments, ClassLoader classLoader) {
        List<String> config = arguments.repeatedParameter("--config", null);
        String output = arguments.parameter("--output", null);
        List<String> models = arguments.positionalArguments();
        LOGGER.info(String.format("Building Smithy model sources: %s", models));
        SmithyBuildConfig.Builder configBuilder = SmithyBuildConfig.builder();
        if (config == null && Files.exists(Paths.get("smithy-build.json", new String[0]), new LinkOption[0])) {
            config = Collections.singletonList("smithy-build.json");
        }
        if (config != null) {
            LOGGER.info(String.format("Loading Smithy configs: [%s]", String.join((CharSequence)" ", config)));
            config.forEach(file -> configBuilder.load(Paths.get(file, new String[0])));
        }
        if (output != null) {
            configBuilder.outputDirectory(output);
            try {
                Files.createDirectories(Paths.get(output, new String[0]), new FileAttribute[0]);
                LOGGER.fine(String.format("Output directory set to: %s", output));
            }
            catch (IOException e) {
                throw new CliError("Unable to create Smithy output directory: " + e.getMessage());
            }
        }
        SmithyBuildConfig smithyBuildConfig = configBuilder.build();
        ValidatedResult<Model> sourceResult = this.buildModel(classLoader, models, arguments);
        Model model = (Model)sourceResult.unwrap();
        SmithyBuild smithyBuild = SmithyBuild.create((ClassLoader)classLoader).config(smithyBuildConfig).model(model);
        if (arguments.has("--plugin")) {
            smithyBuild.pluginFilter(name -> name.equals(arguments.parameter("--plugin")));
        }
        if (arguments.has("--projection")) {
            smithyBuild.projectionFilter(name -> name.equals(arguments.parameter("--projection")));
        }
        models.forEach(path -> smithyBuild.registerSources(new Path[]{Paths.get(path, new String[0])}));
        SmithyBuildResult smithyBuildResult = smithyBuild.build();
        if (smithyBuildResult.anyBroken()) {
            throw new CliError("One or more projections contained ERROR or unsuppressed DANGER events");
        }
        Colors.out(Colors.BRIGHT_BOLD_GREEN, "Smithy build successfully generated the following artifacts");
        smithyBuildResult.allArtifacts().map(Path::toString).sorted().forEach(System.out::println);
    }

    private ValidatedResult<Model> buildModel(ClassLoader classLoader, List<String> models, Arguments arguments) {
        ModelAssembler assembler = Model.assembler((ClassLoader)classLoader);
        CommandUtils.handleModelDiscovery(arguments, assembler, classLoader);
        CommandUtils.handleUnknownTraitsOption(arguments, assembler);
        models.forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        ValidatedResult result = assembler.assemble();
        Validator.validate((ValidatedResult<Model>)result, true);
        return result;
    }
}

