/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import software.amazon.smithy.cli.Arguments;
import software.amazon.smithy.cli.CliError;
import software.amazon.smithy.cli.Colors;
import software.amazon.smithy.cli.Command;
import software.amazon.smithy.cli.Parser;

public final class Cli {
    public static final String HELP = "--help";
    public static final String NO_COLOR = "--no-color";
    public static final String FORCE_COLOR = "--force-color";
    public static final String DEBUG = "--debug";
    public static final String STACKTRACE = "--stacktrace";
    public static final String QUIET_LOGS = "--quiet-logs";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private final String applicationName;
    private final ClassLoader classLoader;
    private boolean configureLogging;
    private Map<String, Command> commands = new TreeMap<String, Command>();

    public Cli(String applicationName) {
        this(applicationName, Cli.class.getClassLoader());
    }

    public Cli(String applicationName, ClassLoader classLoader) {
        this.applicationName = applicationName;
        this.classLoader = classLoader;
    }

    public void addCommand(Command command) {
        this.commands.put(command.getName(), command);
    }

    public void configureLogging(boolean configureLogging) {
        this.configureLogging = configureLogging;
    }

    public void run(String[] args) {
        block10: {
            try {
                if (args.length == 0) {
                    this.printMainHelp();
                    return;
                }
                String argument = args[0];
                if (argument.equals("-h") || argument.equals(HELP)) {
                    this.printMainHelp();
                    break block10;
                }
                if (this.commands.containsKey(argument)) {
                    Command command = this.commands.get(argument);
                    Parser parser = command.getParser();
                    Arguments parsedArguments = parser.parse(args, 1);
                    if (parsedArguments.has(NO_COLOR)) {
                        Colors.setUseAnsiColors(false);
                    } else if (parsedArguments.has(FORCE_COLOR)) {
                        Colors.setUseAnsiColors(true);
                    }
                    if (parsedArguments.has(HELP)) {
                        this.printHelp(command, parser);
                    } else {
                        this.configureLogging(args);
                        command.execute(parsedArguments, this.classLoader);
                    }
                    break block10;
                }
                throw new CliError("Unknown command or argument: '" + argument + "'", 1);
            }
            catch (Exception e) {
                this.printException(args, e);
                throw e;
            }
        }
    }

    private void configureLogging(String[] args) {
        if (this.configureLogging && !this.hasArgument(args, QUIET_LOGS)) {
            Handler handler = Cli.getConsoleHandler();
            if (this.hasArgument(args, DEBUG)) {
                handler.setFormatter(new DebugFormatter());
                handler.setLevel(Level.ALL);
                Logger rootLogger = LogManager.getLogManager().getLogger("");
                rootLogger.setLevel(Level.ALL);
                for (Handler h : rootLogger.getHandlers()) {
                    h.setLevel(Level.ALL);
                }
            } else {
                handler.setFormatter(new BasicFormatter());
                handler.setLevel(Level.WARNING);
            }
        }
    }

    private static Handler getConsoleHandler() {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            return handler;
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        rootLogger.addHandler(consoleHandler);
        return consoleHandler;
    }

    private boolean hasArgument(String[] args, String name) {
        for (String arg : args) {
            if (!arg.equals(name)) continue;
            return true;
        }
        return false;
    }

    private void printException(String[] args, Throwable throwable) {
        if (this.hasArgument(args, NO_COLOR)) {
            Colors.setUseAnsiColors(false);
        }
        Colors.out(Colors.BOLD_RED, throwable.getMessage());
        if (this.hasArgument(args, STACKTRACE)) {
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            String trace = sw.toString();
            Colors.out(Colors.RED, trace);
        }
    }

    private void printMainHelp() {
        Colors.out(Colors.BRIGHT_WHITE, String.format("Usage: %s [-h | --help] <command> [<args>]%n", this.applicationName));
        System.out.println("commands:");
        LinkedHashMap<String, String> table = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Command> entry : this.commands.entrySet()) {
            table.put("  " + entry.getKey(), entry.getValue().getSummary());
        }
        System.out.println(this.createTable(table).trim());
    }

    private String createTable(Map<String, String> table) {
        StringBuilder builder = new StringBuilder();
        int longestLen = table.keySet().stream().map(String::length).mapToInt(v -> v).max().orElse(0) + 4;
        table.forEach((k, v) -> {
            int padding = longestLen - k.length();
            builder.append((String)k);
            for (int i = 0; i < padding; ++i) {
                builder.append(" ");
            }
            builder.append((String)v).append("\n");
        });
        return builder.toString();
    }

    private void printHelp(Command command, Parser parser) {
        StringBuilder example = new StringBuilder();
        example.append(this.applicationName).append(" ").append(command.getName());
        parser.getArgs().forEach(arg -> {
            if (!arg.getLongName().filter(name -> name.equals(HELP)).isPresent()) {
                example.append(" [");
                arg.getShortName().ifPresent(example::append);
                if (arg.getShortName().isPresent() && arg.getLongName().isPresent()) {
                    example.append(" | ");
                }
                arg.getLongName().ifPresent(example::append);
                if (arg.getArity() == Parser.Arity.MANY) {
                    example.append(" ...");
                }
                example.append("]");
            }
        });
        parser.getPositionalName().ifPresent(name -> example.append(" ").append((String)name));
        Colors.out(Colors.BRIGHT_WHITE, example.append("\n").toString());
        StringBuilder body = new StringBuilder();
        body.append(command.getSummary()).append("\n\n");
        LinkedHashMap<String, String> table = new LinkedHashMap<String, String>();
        parser.getArgs().forEach(arg -> {
            StringBuilder key = new StringBuilder("  ");
            arg.getShortName().ifPresent(key::append);
            if (arg.getShortName().isPresent() && arg.getLongName().isPresent()) {
                key.append(" | ");
            }
            arg.getLongName().ifPresent(key::append);
            if (arg.getArity() == Parser.Arity.MANY) {
                key.append(" ...");
            }
            table.put(key.toString(), arg.getHelp());
        });
        parser.getPositionalName().ifPresent(name -> table.put("  " + name + "  ", parser.getPositionalHelp().orElse("")));
        body.append("  ").append(this.createTable(table).trim());
        String help = command.getHelp();
        if (!help.isEmpty()) {
            body.append("\n\n").append(command.getHelp().trim());
        }
        System.out.println(body);
    }

    private static final class DebugFormatter
    extends SimpleFormatter {
        private DebugFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            return FORMAT.format(new Date(r.getMillis())) + " [" + r.getLevel().getLocalizedName() + "] [" + r.getLoggerName() + "] " + r.getMessage() + System.lineSeparator();
        }
    }

    private static final class BasicFormatter
    extends SimpleFormatter {
        private BasicFormatter() {
        }

        @Override
        public synchronized String format(LogRecord r) {
            return FORMAT.format(new Date(r.getMillis())) + " [" + r.getLevel().getLocalizedName() + "] " + r.getMessage() + System.lineSeparator();
        }
    }
}

