/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.logging.Logger;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.ConfigurableProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;

abstract class BackwardCompatHelper<T>
extends ConfigurableProjectionTransformer<T> {
    private static final Logger LOGGER = Logger.getLogger(BackwardCompatHelper.class.getName());
    private static final String ARGS = "__args";

    BackwardCompatHelper() {
    }

    abstract String getBackwardCompatibleNameMapping();

    @Override
    public final Model transform(TransformContext context) {
        ObjectNode original = context.getSettings();
        if (!original.getMember(ARGS).isPresent()) {
            return super.transform(context);
        }
        LOGGER.warning(() -> String.format("Deprecated projection transform arguments detected for `%s`; change this list of strings to an object with a property named `%s`", this.getName(), this.getBackwardCompatibleNameMapping()));
        ObjectNode updated = original.toBuilder().withMember(this.getBackwardCompatibleNameMapping(), (ToNode)original.getMember(ARGS).get()).withoutMember(ARGS).build();
        return super.transform(context.toBuilder().settings(updated).build());
    }
}

