/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collections;
import java.util.Set;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class IncludeNamespaces
extends BackwardCompatHelper<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "includeNamespaces";
    }

    @Override
    String getBackwardCompatibleNameMapping() {
        return "namespaces";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        Set<String> namespaces = config.getNamespaces();
        Model model = context.getModel();
        ModelTransformer transformer = context.getTransformer();
        return transformer.filterShapes(model, shape -> Prelude.isPreludeShape((ToShapeId)shape) || namespaces.contains(shape.getId().getNamespace()));
    }

    public static final class Config {
        private Set<String> namespaces = Collections.emptySet();

        public Set<String> getNamespaces() {
            return this.namespaces;
        }

        public void setNamespaces(Set<String> namespaces) {
            this.namespaces = namespaces;
        }
    }
}

