/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.BackwardCompatHelper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.Tagged;

public final class ExcludeTraitsByTag
extends BackwardCompatHelper<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    public String getName() {
        return "excludeTraitsByTag";
    }

    @Override
    String getBackwardCompatibleNameMapping() {
        return "tags";
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        Model model = context.getModel();
        ModelTransformer transformer = context.getTransformer();
        Set<String> tags = config.getTags();
        return transformer.removeShapesIf(model, shape -> this.removeIfPredicate((Shape)shape, (Collection<String>)tags));
    }

    private boolean removeIfPredicate(Shape shape, Collection<String> tags) {
        return !Prelude.isPreludeShape((ToShapeId)shape) && shape.hasTrait(TraitDefinition.ID) && this.hasAnyTag((Tagged)shape, tags);
    }

    private boolean hasAnyTag(Tagged tagged, Collection<String> tags) {
        return tagged.getTags().stream().anyMatch(tags::contains);
    }

    public static final class Config {
        private Set<String> tags = Collections.emptySet();

        public Set<String> getTags() {
            return this.tags;
        }

        public void setTags(Set<String> tags) {
            this.tags = tags;
        }
    }
}

