/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.model.ProjectionConfig;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class PluginContext
implements ToSmithyBuilder<PluginContext> {
    private final ProjectionConfig projection;
    private final String projectionName;
    private final Model model;
    private final Model originalModel;
    private final List<ValidationEvent> events;
    private final ObjectNode settings;
    private final FileManifest fileManifest;
    private final FileManifest sharedFileManifest;
    private final ClassLoader pluginClassLoader;
    private final Set<Path> sources;
    private final String artifactName;
    private final List<String> sourceUris;
    private Model nonTraitsModel;

    private PluginContext(Builder builder) {
        this.model = (Model)SmithyBuilder.requiredState((String)"model", (Object)builder.model);
        this.fileManifest = (FileManifest)SmithyBuilder.requiredState((String)"fileManifest", (Object)builder.fileManifest);
        this.sharedFileManifest = builder.sharedFileManifest;
        this.artifactName = builder.artifactName;
        this.projection = builder.projection;
        this.projectionName = builder.projectionName;
        this.originalModel = builder.originalModel;
        this.events = Collections.unmodifiableList(builder.events);
        this.settings = builder.settings;
        this.pluginClassLoader = builder.pluginClassLoader;
        this.sources = (Set)builder.sources.copy();
        this.sourceUris = new ArrayList<String>(this.sources.size());
        for (Path source : this.sources) {
            this.sourceUris.add(source.toUri().toString());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<ProjectionConfig> getProjection() {
        return Optional.ofNullable(this.projection);
    }

    public String getProjectionName() {
        return this.projectionName;
    }

    public Optional<String> getArtifactName() {
        return Optional.ofNullable(this.artifactName);
    }

    public Model getModel() {
        return this.model;
    }

    public Optional<Model> getOriginalModel() {
        return Optional.ofNullable(this.originalModel);
    }

    public List<ValidationEvent> getEvents() {
        return this.events;
    }

    public ObjectNode getSettings() {
        return this.settings;
    }

    public FileManifest getFileManifest() {
        return this.fileManifest;
    }

    public FileManifest getSharedFileManifest() {
        if (this.sharedFileManifest == null) {
            SmithyBuilder.requiredState((String)"sharedFileManifest", (Object)this.sharedFileManifest);
        }
        return this.sharedFileManifest;
    }

    public Optional<ClassLoader> getPluginClassLoader() {
        return Optional.ofNullable(this.pluginClassLoader);
    }

    public synchronized Model getModelWithoutTraitShapes() {
        if (this.nonTraitsModel == null) {
            this.nonTraitsModel = ModelTransformer.create().getModelWithoutTraitShapes(this.model);
        }
        return this.nonTraitsModel;
    }

    public Set<Path> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    public boolean isSourceShape(ToShapeId shape) {
        return this.originalModel == null || this.isSource(this.originalModel.getShape(shape.toShapeId()).orElse(null));
    }

    public boolean isSourceMetadata(String metadataKey) {
        return this.originalModel == null || this.isSource(this.originalModel.getMetadataProperty(metadataKey).orElse(null));
    }

    private boolean isSource(FromSourceLocation sourceLocation) {
        if (sourceLocation == null) {
            return true;
        }
        String location = sourceLocation.getSourceLocation().getFilename();
        int offsetFromStart = this.findOffsetFromStart(location);
        if (offsetFromStart > 0) {
            for (String sourceUri : this.sourceUris) {
                int regionCompareLength;
                if (!location.regionMatches(offsetFromStart, sourceUri, 5, regionCompareLength = sourceUri.length() - 5)) continue;
                return true;
            }
            return false;
        }
        for (Path path : this.sources) {
            int offsetFromStartInSource;
            String pathString = path.toString();
            if (!location.regionMatches(offsetFromStart, pathString, offsetFromStartInSource = this.findOffsetFromStart(pathString), pathString.length())) continue;
            return true;
        }
        return false;
    }

    private int findOffsetFromStart(String location) {
        int position = location.indexOf("file:");
        return position == -1 ? 0 : position + "file:".length();
    }

    public Builder toBuilder() {
        Builder builder = PluginContext.builder().model(this.model).events(this.events).settings(this.settings).fileManifest(this.fileManifest).sharedFileManifest(this.sharedFileManifest).pluginClassLoader(this.pluginClassLoader).sources(this.sources).artifactName(this.artifactName);
        this.getProjection().ifPresent(config -> builder.projection(this.projectionName, (ProjectionConfig)config));
        this.getOriginalModel().ifPresent(builder::originalModel);
        return builder;
    }

    public static final class Builder
    implements SmithyBuilder<PluginContext> {
        private ProjectionConfig projection;
        private String projectionName = "source";
        private Model model;
        private Model originalModel;
        private List<ValidationEvent> events = Collections.emptyList();
        private ObjectNode settings = Node.objectNode();
        private FileManifest fileManifest;
        private FileManifest sharedFileManifest;
        private ClassLoader pluginClassLoader;
        private final BuilderRef<Set<Path>> sources = BuilderRef.forOrderedSet();
        private String artifactName;

        private Builder() {
        }

        public PluginContext build() {
            return new PluginContext(this);
        }

        public Builder fileManifest(FileManifest fileManifest) {
            this.fileManifest = fileManifest;
            return this;
        }

        public Builder sharedFileManifest(FileManifest sharedFileManifest) {
            this.sharedFileManifest = sharedFileManifest;
            return this;
        }

        public Builder model(Model model) {
            this.model = Objects.requireNonNull(model);
            return this;
        }

        public Builder projection(String name, ProjectionConfig projection) {
            this.projectionName = Objects.requireNonNull(name);
            this.projection = Objects.requireNonNull(projection);
            return this;
        }

        public Builder originalModel(Model originalModel) {
            this.originalModel = Objects.requireNonNull(originalModel);
            return this;
        }

        public Builder events(List<ValidationEvent> events) {
            this.events = Objects.requireNonNull(events);
            return this;
        }

        public Builder settings(ObjectNode settings) {
            this.settings = Objects.requireNonNull(settings);
            return this;
        }

        public Builder pluginClassLoader(ClassLoader pluginClassLoader) {
            this.pluginClassLoader = pluginClassLoader;
            return this;
        }

        public Builder sources(Collection<Path> sources) {
            this.sources.clear();
            ((Set)this.sources.get()).addAll(sources);
            return this;
        }

        public Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }
    }
}

