/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.ConfigurableProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class RemoveTraitDefinitions
extends ConfigurableProjectionTransformer<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        Model model = context.getModel();
        ModelTransformer transformer = context.getTransformer();
        Predicate<Shape> keepTraitDefsByTag = trait -> config.getExportTagged().stream().noneMatch(arg_0 -> ((Shape)trait).hasTag(arg_0));
        return transformer.getModelWithoutTraitShapes(model, keepTraitDefsByTag);
    }

    @Override
    public String getName() {
        return "removeTraitDefinitions";
    }

    public static final class Config {
        private Set<String> exportTagged = Collections.emptySet();

        public void setExportTagged(Set<String> exportByTags) {
            this.exportTagged = exportByTags;
        }

        public Set<String> getExportTagged() {
            return this.exportTagged;
        }
    }
}

