/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.model.ProjectionConfig;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.Pair;

final class ConfigLoader {
    private ConfigLoader() {
    }

    static SmithyBuildConfig load(Path path) {
        try {
            String content = IoUtils.readUtf8File((Path)path);
            return ConfigLoader.load(path.getParent(), ConfigLoader.loadWithJson(path, content).expectObjectNode());
        }
        catch (ModelSyntaxException e) {
            throw new SmithyBuildException(e);
        }
    }

    private static Node loadWithJson(Path path, String contents) {
        return (Node)Node.parseJsonWithComments((String)contents, (String)path.toString()).accept((NodeVisitor)new VariableExpander());
    }

    private static SmithyBuildConfig load(Path baseImportPath, ObjectNode node) {
        NodeMapper mapper = new NodeMapper();
        return ConfigLoader.resolveImports(baseImportPath, (SmithyBuildConfig)mapper.deserialize((Node)node, SmithyBuildConfig.class));
    }

    private static SmithyBuildConfig resolveImports(Path baseImportPath, SmithyBuildConfig config) {
        List<String> imports = config.getImports().stream().map(importPath -> baseImportPath.resolve((String)importPath).toString()).collect(Collectors.toList());
        Map<String, ProjectionConfig> projections = config.getProjections().entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)ConfigLoader.resolveProjectionImports(baseImportPath, (ProjectionConfig)entry.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return config.toBuilder().imports(imports).projections(projections).build();
    }

    private static ProjectionConfig resolveProjectionImports(Path baseImportPath, ProjectionConfig config) {
        List<String> imports = config.getImports().stream().map(importPath -> baseImportPath.resolve((String)importPath).toString()).collect(Collectors.toList());
        return config.toBuilder().imports(imports).build();
    }

    private static final class VariableExpander
    extends NodeVisitor.Default<Node> {
        private static final Pattern INLINE = Pattern.compile("(?:^|[^\\\\])\\$\\{(.+)}");
        private static final Pattern ESCAPED_INLINE = Pattern.compile("\\\\\\$");

        private VariableExpander() {
        }

        protected Node getDefault(Node node) {
            return node;
        }

        public Node arrayNode(ArrayNode node) {
            return (Node)node.getElements().stream().map(element -> (Node)element.accept((NodeVisitor)this)).collect(ArrayNode.collect());
        }

        public Node objectNode(ObjectNode node) {
            return (Node)node.getMembers().entrySet().stream().map(entry -> Pair.of((Object)((Node)((StringNode)entry.getKey()).accept((NodeVisitor)this)), (Object)((Node)((Node)entry.getValue()).accept((NodeVisitor)this)))).collect(ObjectNode.collect(pair -> ((Node)pair.getLeft()).expectStringNode(), Pair::getRight));
        }

        public Node stringNode(StringNode node) {
            Matcher matcher = INLINE.matcher(node.getValue());
            StringBuffer builder = new StringBuffer();
            while (matcher.find()) {
                String variable = matcher.group(1);
                String replacement = VariableExpander.expand(node.getSourceLocation(), variable);
                if (!matcher.group(0).startsWith("${")) {
                    replacement = matcher.group(0).charAt(0) + replacement;
                }
                matcher.appendReplacement(builder, replacement);
            }
            matcher.appendTail(builder);
            String result = ESCAPED_INLINE.matcher(builder.toString()).replaceAll("\\$");
            return new StringNode(result, node.getSourceLocation());
        }

        private static String expand(SourceLocation sourceLocation, String variable) {
            String replacement = Optional.ofNullable(System.getProperty(variable)).orElseGet(() -> System.getenv(variable));
            if (replacement == null) {
                throw new SmithyBuildException(String.format("Unable to expand variable `" + variable + "` to an environment variable or system property: %s", sourceLocation));
            }
            return replacement;
        }
    }
}

