/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.ConfigurableProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class RemoveDeprecatedShapes
extends ConfigurableProjectionTransformer<Config> {
    @Override
    public String getName() {
        return "removeDeprecatedShapes";
    }

    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        Model model = context.getModel();
        ModelTransformer transformer = context.getTransformer();
        model = transformer.filterDeprecatedRelativeDate(model, config.getRelativeDate());
        model = transformer.filterDeprecatedRelativeVersion(model, config.getRelativeVersion());
        return model;
    }

    public static final class Config {
        private String relativeDate;
        private String relativeVersion;

        public String getRelativeDate() {
            return this.relativeDate;
        }

        public void setRelativeDate(String relativeDate) {
            this.relativeDate = relativeDate;
        }

        public String getRelativeVersion() {
            return this.relativeVersion;
        }

        public void setRelativeVersion(String relativeVersion) {
            this.relativeVersion = relativeVersion;
        }
    }
}

