/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.processor;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import software.amazon.smithy.build.SmithyBuild;
import software.amazon.smithy.build.SmithyBuildResult;
import software.amazon.smithy.build.model.SmithyBuildConfig;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.loader.ModelDiscovery;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.utils.IoUtils;

public abstract class SmithyAnnotationProcessor<A extends Annotation>
extends AbstractProcessor {
    private static final String MANIFEST_PATH = "META-INF/smithy/manifest";
    private Messager messager;
    private Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(this.getAnnotationClass());
        if (elements.size() > 1) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Only one package can have the " + this.getAnnotationClass() + " annotation.");
        } else if (elements.size() == 1) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Executing processor: " + this.getClass().getSimpleName() + "...");
            String packageName = this.getPackageName(elements.iterator().next());
            SmithyBuildConfig config = this.createBuildConfig(this.getAnnotation(elements), packageName);
            this.executeSmithyBuild(config).allArtifacts().filter(path -> path.toString().contains(this.getPluginName()) && path.toString().contains("source")).forEach(this::writeArtifact);
        }
        return false;
    }

    protected abstract String getPluginName();

    protected abstract Class<A> getAnnotationClass();

    protected abstract ObjectNode createPluginNode(A var1, String var2);

    private SmithyBuildConfig createBuildConfig(A annotation, String packageName) {
        HashMap<String, ObjectNode> pluginMap = new HashMap<String, ObjectNode>();
        pluginMap.put(this.getPluginName(), this.createPluginNode(annotation, packageName));
        return SmithyBuildConfig.builder().version("1.0").plugins(pluginMap).build();
    }

    private SmithyBuildResult executeSmithyBuild(SmithyBuildConfig config) {
        ModelAssembler assembler = Model.assembler();
        assembler.discoverModels(this.getClass().getClassLoader());
        ModelDiscovery.findModels((URL)this.getManifestUrl()).forEach(arg_0 -> ((ModelAssembler)assembler).addImport(arg_0));
        SmithyBuild smithyBuild = SmithyBuild.create(this.getClass().getClassLoader());
        smithyBuild.model((Model)assembler.assemble().unwrap());
        smithyBuild.config(config);
        return smithyBuild.build();
    }

    private void writeArtifact(Path path) {
        block16: {
            String pathStr = path.toString();
            String outputPath = pathStr.substring(pathStr.lastIndexOf(this.getPluginName()) + this.getPluginName().length() + 1);
            try {
                if (outputPath.startsWith("META-INF")) {
                    try (Writer writer = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.convertOutputPath(outputPath), new Element[0]).openWriter();){
                        writer.write(IoUtils.readUtf8File((Path)path));
                        break block16;
                    }
                }
                if (outputPath.endsWith(".java")) {
                    String javaPath = outputPath.replace(FileSystems.getDefault().getSeparator(), ".").substring(0, outputPath.lastIndexOf(".java"));
                    try (Writer writer = this.filer.createSourceFile(javaPath, new Element[0]).openWriter();){
                        writer.write(IoUtils.readUtf8File((Path)path));
                        break block16;
                    }
                }
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Ignoring generated file: " + outputPath);
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }
    }

    private A getAnnotation(Set<? extends Element> elements) {
        return (A)elements.stream().findFirst().map(element -> element.getAnnotation(this.getAnnotationClass())).orElseThrow(() -> new IllegalStateException("No annotation of type " + this.getAnnotationClass() + " found on element."));
    }

    private URL getManifestUrl() {
        try {
            return this.filer.getResource(StandardLocation.CLASS_PATH, "", MANIFEST_PATH).toUri().toURL();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String convertOutputPath(String outputPath) {
        return outputPath.replace(FileSystems.getDefault().getSeparator(), "/");
    }

    private String getPackageName(Element element) {
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            return packageElement.getQualifiedName().toString();
        }
        throw new IllegalStateException("Expected Annotation to be applied to package element but found : " + element);
    }
}

