/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.transforms;

import java.util.HashMap;
import java.util.Map;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.TransformContext;
import software.amazon.smithy.build.transforms.ConfigurableProjectionTransformer;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIdSyntaxException;
import software.amazon.smithy.model.transform.ModelTransformer;

public final class RenameShapes
extends ConfigurableProjectionTransformer<Config> {
    @Override
    public Class<Config> getConfigType() {
        return Config.class;
    }

    @Override
    protected Model transformWithConfig(TransformContext context, Config config) {
        if (config.getRenamed() == null || config.getRenamed().isEmpty()) {
            throw new SmithyBuildException("'renamed' property must be set and non-empty on renameShapes transformer.");
        }
        Model model = context.getModel();
        return ModelTransformer.create().renameShapes(model, this.getShapeIdsToRename(config, model));
    }

    @Override
    public String getName() {
        return "renameShapes";
    }

    private Map<ShapeId, ShapeId> getShapeIdsToRename(Config config, Model model) {
        HashMap<ShapeId, ShapeId> shapeIdMap = new HashMap<ShapeId, ShapeId>();
        for (String fromShape : config.getRenamed().keySet()) {
            ShapeId fromShapeId = this.getShapeIdFromString(fromShape);
            if (!model.getShape(fromShapeId.toShapeId()).isPresent()) {
                throw new SmithyBuildException(String.format("'%s' to be renamed does not exist in model.", fromShapeId));
            }
            shapeIdMap.put(fromShapeId, this.getShapeIdFromString(config.getRenamed().get(fromShape)));
        }
        return shapeIdMap;
    }

    private ShapeId getShapeIdFromString(String id) {
        try {
            return ShapeId.from((String)id);
        }
        catch (ShapeIdSyntaxException e) {
            throw new SmithyBuildException(String.format("'%s' must be a valid, absolute shape ID", id));
        }
    }

    public static final class Config {
        private Map<String, String> renamed;

        public void setRenamed(Map<String, String> renamed) {
            this.renamed = renamed;
        }

        public Map<String, String> getRenamed() {
            return this.renamed;
        }
    }
}

