/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.build.model.MavenRepository;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MavenConfig
implements ToSmithyBuilder<MavenConfig> {
    private final Set<String> dependencies;
    private final Set<MavenRepository> repositories;

    private MavenConfig(Builder builder) {
        this.dependencies = (Set)builder.dependencies.copy();
        this.repositories = (Set)builder.repositories.copy();
    }

    public static MavenConfig fromNode(Node node) {
        Builder builder = MavenConfig.builder();
        node.expectObjectNode().warnIfAdditionalProperties((Collection)ListUtils.of((Object)"dependencies", (Object)"repositories")).getArrayMember("dependencies", StringNode::getValue, builder::dependencies).getArrayMember("repositories", MavenRepository::fromNode, builder::repositories);
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<MavenRepository> getRepositories() {
        return this.repositories;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public MavenConfig merge(MavenConfig other) {
        Builder builder = this.toBuilder();
        ((Set)builder.dependencies.get()).addAll(other.getDependencies());
        if (other.repositories != null) {
            ((Set)builder.repositories.get()).addAll(other.repositories);
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return MavenConfig.builder().repositories(this.repositories).dependencies(this.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.dependencies, this.repositories);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MavenConfig)) {
            return false;
        }
        MavenConfig other = (MavenConfig)obj;
        return this.dependencies.equals(other.dependencies) && Objects.equals(this.repositories, other.repositories);
    }

    public static final class Builder
    implements SmithyBuilder<MavenConfig> {
        private final BuilderRef<Set<String>> dependencies = BuilderRef.forOrderedSet();
        private final BuilderRef<Set<MavenRepository>> repositories = BuilderRef.forOrderedSet();

        private Builder() {
        }

        public MavenConfig build() {
            return new MavenConfig(this);
        }

        public Builder dependencies(Collection<String> dependencies) {
            this.dependencies.clear();
            ((Set)this.dependencies.get()).addAll(dependencies);
            return this;
        }

        public Builder repositories(Collection<MavenRepository> repositories) {
            this.repositories.clear();
            if (repositories != null) {
                ((Set)this.repositories.get()).addAll(repositories);
            }
            return this;
        }
    }
}

