/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.plugins;

import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.build.SmithyBuildPlugin;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.BoxTrait;

public final class NullabilityReportPlugin
implements SmithyBuildPlugin {
    static final String NULLABILITY_REPORT_PATH = "nullability-report.json";
    private static final String NAME = "nullabilityReport";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean requiresValidModel() {
        return false;
    }

    @Override
    public void execute(PluginContext context) {
        if (context.getOriginalModel().isPresent() && context.getProjection().isPresent()) {
            context.getFileManifest().writeJson(NULLABILITY_REPORT_PATH, NullabilityReportPlugin.serializeReport(context));
        }
    }

    private static Node serializeReport(PluginContext context) {
        ObjectNode.Builder root = Node.objectNodeBuilder();
        Model model = context.getModel();
        NullableIndex index = NullableIndex.of((Model)model);
        for (StructureShape structure : model.getStructureShapes()) {
            if (structure.getAllMembers().isEmpty() || !context.isSourceShape((ToShapeId)structure)) continue;
            ObjectNode.Builder struct = Node.objectNodeBuilder();
            for (MemberShape member : structure.getAllMembers().values()) {
                ObjectNode.Builder entry = Node.objectNodeBuilder();
                entry.withMember("v1", index.isNullable((ToShapeId)member));
                entry.withMember("v1-via-box", member.getMemberTrait(model, BoxTrait.class).isPresent());
                entry.withMember("v2-client", index.isMemberNullable(member, NullableIndex.CheckMode.CLIENT));
                entry.withMember("v2-client-careful", index.isMemberNullable(member, NullableIndex.CheckMode.CLIENT_CAREFUL));
                entry.withMember("v2-client-zero-value", index.isMemberNullable(member, NullableIndex.CheckMode.CLIENT_ZERO_VALUE_V1));
                entry.withMember("v2-client-zero-value-no-input", index.isMemberNullable(member, NullableIndex.CheckMode.CLIENT_ZERO_VALUE_V1_NO_INPUT));
                entry.withMember("v2-server", index.isMemberNullable(member, NullableIndex.CheckMode.SERVER));
                struct.withMember(member.getMemberName(), (ToNode)entry.build());
            }
            root.withMember(structure.getId().toString(), (ToNode)struct.build());
        }
        return root.build();
    }
}

