/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class MavenRepository
implements ToSmithyBuilder<MavenRepository> {
    private final String url;
    private final String httpCredentials;

    public MavenRepository(Builder builder) {
        this.url = (String)SmithyBuilder.requiredState((String)"url", (Object)builder.url);
        this.httpCredentials = builder.httpCredentials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MavenRepository fromNode(Node node) {
        Builder builder = MavenRepository.builder();
        node.expectObjectNode().warnIfAdditionalProperties(Arrays.asList("url", "httpCredentials")).expectStringMember("url", builder::url).getStringMember("httpCredentials", builder::httpCredentials);
        return builder.build();
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<String> getHttpCredentials() {
        return Optional.ofNullable(this.httpCredentials);
    }

    public Builder toBuilder() {
        return MavenRepository.builder().url(this.url).httpCredentials(this.httpCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.httpCredentials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MavenRepository)) {
            return false;
        }
        MavenRepository mavenRepo = (MavenRepository)o;
        return Objects.equals(this.url, mavenRepo.url) && Objects.equals(this.httpCredentials, mavenRepo.httpCredentials);
    }

    public static final class Builder
    implements SmithyBuilder<MavenRepository> {
        private String url;
        private String httpCredentials;

        private Builder() {
        }

        public MavenRepository build() {
            return new MavenRepository(this);
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder httpCredentials(String httpCredentials) {
            int position;
            this.httpCredentials = httpCredentials;
            if (httpCredentials != null && ((position = httpCredentials.indexOf(58)) < 1 || position == httpCredentials.length() - 1)) {
                throw new IllegalArgumentException("Invalid httpCredentials: expected in the format of user:pass");
            }
            return this;
        }
    }
}

