/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.build.model.MavenConfig;
import software.amazon.smithy.build.model.ProjectionConfig;
import software.amazon.smithy.build.model.SmithyBuildUtils;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SmithyBuildConfig
implements ToSmithyBuilder<SmithyBuildConfig> {
    private static final Set<String> BUILTIN_PLUGINS = SetUtils.of((Object[])new String[]{"build-info", "model", "sources"});
    private final String version;
    private final List<String> sources;
    private final List<String> imports;
    private final String outputDirectory;
    private final Map<String, ProjectionConfig> projections;
    private final Map<String, ObjectNode> plugins;
    private final boolean ignoreMissingPlugins;
    private final MavenConfig maven;
    private final long lastModifiedInMillis;

    private SmithyBuildConfig(Builder builder) {
        SmithyBuilder.requiredState((String)"version", (Object)builder.version);
        this.version = builder.version;
        this.outputDirectory = builder.outputDirectory;
        this.sources = (List)builder.sources.copy();
        this.imports = (List)builder.imports.copy();
        this.projections = (Map)builder.projections.copy();
        this.plugins = (Map)builder.plugins.copy();
        this.ignoreMissingPlugins = builder.ignoreMissingPlugins;
        this.maven = builder.maven;
        this.lastModifiedInMillis = builder.lastModifiedInMillis;
        if (this.outputDirectory != null && this.outputDirectory.isEmpty()) {
            throw new IllegalArgumentException("outputDirectory must be set to a valid directory");
        }
    }

    public static SmithyBuildConfig fromNode(Node node) {
        Path path = SmithyBuildUtils.getBasePathFromSourceLocation((FromSourceLocation)node);
        ObjectNode expanded = SmithyBuildUtils.expandNode(node);
        return SmithyBuildConfig.builder().loadNode(path, (Node)expanded).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SmithyBuildConfig load(Path file) {
        return SmithyBuildConfig.builder().load(file).build();
    }

    public Builder toBuilder() {
        return SmithyBuildConfig.builder().version(this.version).outputDirectory(this.outputDirectory).sources(this.sources).imports(this.imports).projections(this.projections).plugins(this.plugins).ignoreMissingPlugins(this.ignoreMissingPlugins).maven(this.maven);
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public Optional<String> getOutputDirectory() {
        return Optional.ofNullable(this.outputDirectory);
    }

    public Map<String, ProjectionConfig> getProjections() {
        return Collections.unmodifiableMap(this.projections);
    }

    public Map<String, ObjectNode> getPlugins() {
        return Collections.unmodifiableMap(this.plugins);
    }

    public boolean isIgnoreMissingPlugins() {
        return this.ignoreMissingPlugins;
    }

    public Optional<MavenConfig> getMaven() {
        return Optional.ofNullable(this.maven);
    }

    public long getLastModifiedInMillis() {
        return this.lastModifiedInMillis;
    }

    public static final class Builder
    implements SmithyBuilder<SmithyBuildConfig> {
        private final BuilderRef<List<String>> imports = BuilderRef.forList();
        private final BuilderRef<List<String>> sources = BuilderRef.forList();
        private final BuilderRef<Map<String, ProjectionConfig>> projections = BuilderRef.forOrderedMap();
        private final BuilderRef<Map<String, ObjectNode>> plugins = BuilderRef.forOrderedMap();
        private String version;
        private String outputDirectory;
        private boolean ignoreMissingPlugins;
        private MavenConfig maven;
        private long lastModifiedInMillis = 0L;

        Builder() {
        }

        public SmithyBuildConfig build() {
            for (String builtin : BUILTIN_PLUGINS) {
                ((Map)this.plugins.get()).put(builtin, Node.objectNode());
            }
            return new SmithyBuildConfig(this);
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder load(Path config) {
            try {
                String content = IoUtils.readUtf8File((Path)config);
                Path basePath = config.getParent();
                if (basePath == null) {
                    basePath = Paths.get(".", new String[0]);
                }
                ObjectNode loadedAndExpanded = SmithyBuildUtils.loadAndExpandJson(config.toString(), content);
                return this.loadNode(basePath, (Node)loadedAndExpanded);
            }
            catch (ModelSyntaxException e) {
                throw new SmithyBuildException(e);
            }
        }

        private Builder loadNode(Path basePath, Node node) {
            node.expectObjectNode().expectStringMember("version", this::version).getStringMember("outputDirectory", this::outputDirectory).getArrayMember("sources", s -> SmithyBuildUtils.resolveImportPath(basePath, s), values -> ((List)this.sources.get()).addAll(values)).getArrayMember("imports", s -> SmithyBuildUtils.resolveImportPath(basePath, s), values -> ((List)this.imports.get()).addAll(values)).getObjectMember("projections", v -> {
                for (Map.Entry entry : v.getStringMap().entrySet()) {
                    ((Map)this.projections.get()).put(entry.getKey(), ProjectionConfig.fromNode((Node)entry.getValue(), basePath));
                }
            }).getObjectMember("plugins", v -> {
                for (Map.Entry entry : v.getStringMap().entrySet()) {
                    ((Map)this.plugins.get()).put(entry.getKey(), ((Node)entry.getValue()).expectObjectNode());
                }
            }).getBooleanMember("ignoreMissingPlugins", this::ignoreMissingPlugins).getMember("maven", MavenConfig::fromNode, this::maven);
            return this;
        }

        public Builder merge(SmithyBuildConfig config) {
            config.getOutputDirectory().ifPresent(this::outputDirectory);
            this.version(config.getVersion());
            ((List)this.sources.get()).addAll(config.getSources());
            ((List)this.imports.get()).addAll(config.getImports());
            ((Map)this.projections.get()).putAll(config.getProjections());
            ((Map)this.plugins.get()).putAll(config.getPlugins());
            if (config.getMaven().isPresent()) {
                this.maven = this.maven == null ? config.maven : this.maven.merge(config.maven);
            }
            if (config.isIgnoreMissingPlugins()) {
                this.ignoreMissingPlugins(config.ignoreMissingPlugins);
            }
            return this;
        }

        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public Builder imports(Collection<String> imports) {
            this.imports.clear();
            ((List)this.imports.get()).addAll(imports);
            return this;
        }

        public Builder sources(Collection<String> sources) {
            this.sources.clear();
            ((List)this.sources.get()).addAll(sources);
            return this;
        }

        public Builder projections(Map<String, ProjectionConfig> projections) {
            this.projections.clear();
            ((Map)this.projections.get()).putAll(projections);
            return this;
        }

        public Builder plugins(Map<String, ObjectNode> plugins) {
            this.plugins.clear();
            ((Map)this.plugins.get()).putAll(plugins);
            return this;
        }

        public Builder ignoreMissingPlugins(boolean ignoreMissingPlugins) {
            this.ignoreMissingPlugins = ignoreMissingPlugins;
            return this;
        }

        public Builder maven(MavenConfig maven) {
            this.maven = maven;
            return this;
        }

        public Builder lastModifiedInMillis(long lastModifiedInMillis) {
            this.lastModifiedInMillis = lastModifiedInMillis;
            return this;
        }
    }
}

