/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build.plugins;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.build.model.ProjectionConfig;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class BuildInfo {
    private String version = "1.0";
    private String projectionName = "source";
    private ProjectionConfig projection;
    private List<ValidationEvent> validationEvents = Collections.emptyList();
    private List<ShapeId> traitNames = Collections.emptyList();
    private List<ShapeId> traitDefNames = Collections.emptyList();
    private List<ShapeId> serviceShapeIds = Collections.emptyList();
    private List<ShapeId> operationShapeIds = Collections.emptyList();
    private List<ShapeId> resourceShapeIds = Collections.emptyList();
    private Map<String, Node> metadata = Collections.emptyMap();

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProjectionName() {
        return this.projectionName;
    }

    public void setProjectionName(String projectionName) {
        this.projectionName = projectionName;
    }

    public ProjectionConfig getProjection() {
        return this.projection;
    }

    public void setProjection(ProjectionConfig projection) {
        this.projection = projection;
    }

    public List<ValidationEvent> getValidationEvents() {
        return this.validationEvents;
    }

    public void setValidationEvents(List<ValidationEvent> validationEvents) {
        this.validationEvents = validationEvents;
    }

    public List<ShapeId> getTraitNames() {
        return this.traitNames;
    }

    public void setTraitNames(List<ShapeId> traitNames) {
        this.traitNames = traitNames;
    }

    public List<ShapeId> getTraitDefNames() {
        return this.traitDefNames;
    }

    public void setTraitDefNames(List<ShapeId> traitDefNames) {
        this.traitDefNames = traitDefNames;
    }

    public List<ShapeId> getServiceShapeIds() {
        return this.serviceShapeIds;
    }

    public void setServiceShapeIds(List<ShapeId> serviceShapeIds) {
        this.serviceShapeIds = serviceShapeIds;
    }

    public List<ShapeId> getOperationShapeIds() {
        return this.operationShapeIds;
    }

    public void setOperationShapeIds(List<ShapeId> operationShapeIds) {
        this.operationShapeIds = operationShapeIds;
    }

    public List<ShapeId> getResourceShapeIds() {
        return this.resourceShapeIds;
    }

    public void setResourceShapeIds(List<ShapeId> resourceShapeIds) {
        this.resourceShapeIds = resourceShapeIds;
    }

    public Map<String, Node> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Node> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildInfo)) {
            return false;
        }
        BuildInfo buildInfo = (BuildInfo)o;
        return Objects.equals(this.getVersion(), buildInfo.getVersion()) && Objects.equals(this.getProjectionName(), buildInfo.getProjectionName()) && Objects.equals(this.getProjection(), buildInfo.getProjection()) && Objects.equals(this.getValidationEvents(), buildInfo.getValidationEvents()) && Objects.equals(this.getTraitNames(), buildInfo.getTraitNames()) && Objects.equals(this.getTraitDefNames(), buildInfo.getTraitDefNames()) && Objects.equals(this.getServiceShapeIds(), buildInfo.getServiceShapeIds()) && Objects.equals(this.getOperationShapeIds(), buildInfo.getOperationShapeIds()) && Objects.equals(this.getResourceShapeIds(), buildInfo.getResourceShapeIds()) && Objects.equals(this.getMetadata(), buildInfo.getMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.getVersion(), this.getProjectionName(), this.getProjection(), this.getValidationEvents(), this.getTraitNames(), this.getTraitDefNames(), this.getServiceShapeIds(), this.getOperationShapeIds(), this.getResourceShapeIds(), this.getMetadata());
    }
}

