/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.build;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.ProjectionResult;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;

public final class SmithyBuildResult {
    private final List<ProjectionResult> results;

    private SmithyBuildResult(Builder builder) {
        this.results = ListUtils.copyOf((Collection)builder.results);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean anyBroken() {
        return this.results.stream().anyMatch(ProjectionResult::isBroken);
    }

    public Stream<Path> allArtifacts() {
        return this.allManifests().flatMap(manifest -> manifest.getFiles().stream());
    }

    public Stream<FileManifest> allManifests() {
        return this.results.stream().flatMap(result -> result.getPluginManifests().values().stream());
    }

    public Optional<ProjectionResult> getProjectionResult(String projectionName) {
        return this.results.stream().filter(result -> result.getProjectionName().equals(projectionName)).findFirst();
    }

    public List<ProjectionResult> getProjectionResults() {
        return this.results;
    }

    public Map<String, ProjectionResult> getProjectionResultsMap() {
        return this.results.stream().collect(Collectors.toMap(ProjectionResult::getProjectionName, Function.identity()));
    }

    public int size() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public static final class Builder
    implements SmithyBuilder<SmithyBuildResult> {
        private final List<ProjectionResult> results = Collections.synchronizedList(new ArrayList());

        private Builder() {
        }

        public SmithyBuildResult build() {
            return new SmithyBuildResult(this);
        }

        public Builder addProjectionResult(ProjectionResult result) {
            this.results.add(result);
            return this;
        }
    }
}

