/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.auth.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.traits.auth.SigV4ATrait;
import software.amazon.smithy.aws.traits.auth.SigV4Trait;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class SigV4Migration
extends AbstractDiffEvaluator {
    public List<ValidationEvent> evaluate(Differences differences) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Model oldModel = differences.getOldModel();
        ServiceIndex oldServiceIndex = ServiceIndex.of((Model)oldModel);
        Model newModel = differences.getNewModel();
        ServiceIndex newServiceIndex = ServiceIndex.of((Model)newModel);
        List serviceChanges = differences.changedShapes(ServiceShape.class).collect(Collectors.toList());
        for (ChangedShape change : serviceChanges) {
            ServiceShape oldServiceShape2 = (ServiceShape)change.getOldShape();
            List<ShapeId> oldAuthSchemes = oldServiceIndex.getEffectiveAuthSchemes((ToShapeId)oldServiceShape2).keySet().stream().collect(Collectors.toList());
            ServiceShape newServiceShape = (ServiceShape)change.getNewShape();
            List<ShapeId> newAuthSchemes = newServiceIndex.getEffectiveAuthSchemes((ToShapeId)newServiceShape).keySet().stream().collect(Collectors.toList());
            this.validateMigration((Shape)newServiceShape, oldAuthSchemes, newAuthSchemes, events);
        }
        Map<OperationShape, Set<ServiceShape>> operationToContainedServiceBindings = SigV4Migration.computeOperationToContainedServiceBindings(newModel);
        List operationChanges = differences.changedShapes(OperationShape.class).collect(Collectors.toList());
        for (ChangedShape change : operationChanges) {
            OperationShape newOperationShape = (OperationShape)change.getNewShape();
            Set<ServiceShape> newOperationServiceBindings = operationToContainedServiceBindings.get(newOperationShape);
            if (newOperationServiceBindings == null) continue;
            for (ServiceShape newServiceShape : newOperationServiceBindings) {
                oldModel.getShape(newServiceShape.getId()).filter(Shape::isServiceShape).map(s -> (ServiceShape)s).ifPresent(oldServiceShape -> {
                    OperationShape oldOperationShape = (OperationShape)change.getOldShape();
                    List<ShapeId> oldAuthSchemes = oldServiceIndex.getEffectiveAuthSchemes((ToShapeId)oldServiceShape, (ToShapeId)oldOperationShape).keySet().stream().collect(Collectors.toList());
                    List<ShapeId> newAuthSchemes = newServiceIndex.getEffectiveAuthSchemes((ToShapeId)newServiceShape, (ToShapeId)newOperationShape).keySet().stream().collect(Collectors.toList());
                    this.validateMigration((Shape)newOperationShape, oldAuthSchemes, newAuthSchemes, events);
                });
            }
        }
        return events;
    }

    private void validateMigration(Shape shape, List<ShapeId> oldAuthSchemes, List<ShapeId> newAuthSchemes, List<ValidationEvent> events) {
        boolean isSigV4AAdded;
        boolean isOldSigV4Present = oldAuthSchemes.contains(SigV4Trait.ID);
        boolean isOldSigV4APresent = oldAuthSchemes.contains(SigV4ATrait.ID);
        boolean isNewSigV4Present = newAuthSchemes.contains(SigV4Trait.ID);
        boolean isNewSigV4APresent = newAuthSchemes.contains(SigV4ATrait.ID);
        boolean isSigV4Replaced = isOldSigV4Present && !isNewSigV4Present && !isOldSigV4APresent && isNewSigV4APresent;
        boolean isSigV4AReplaced = !isOldSigV4Present && isNewSigV4Present && isOldSigV4APresent && !isNewSigV4APresent;
        boolean noSigV4XRemoved = isOldSigV4Present && isNewSigV4Present && isOldSigV4APresent && isNewSigV4APresent;
        boolean isSigV4Added = !isOldSigV4Present && isNewSigV4Present && isOldSigV4APresent && isNewSigV4APresent;
        boolean bl = isSigV4AAdded = isOldSigV4Present && isNewSigV4Present && !isOldSigV4APresent && isNewSigV4APresent;
        if (isSigV4Replaced) {
            events.add(this.danger(shape, "The `aws.auth#sigv4` authentication scheme was replaced by the `aws.auth#sigv4a` authentication scheme in the effective auth schemes for `" + shape.getId() + "`. Replacing the `aws.auth#sigv4` authentication scheme with the `aws.auth#sigv4a` authentication scheme directly is not backward compatible since not all credentials usable by `aws.auth#sigv4` are compatible with `aws.auth#sigv4a`, and can break existing clients' authentication."));
        } else if (isSigV4AReplaced) {
            events.add(this.danger(shape, "The `aws.auth#sigv4a` authentication scheme was replaced by the `aws.auth#sigv4` authentication scheme in the effective auth schemes for `" + shape.getId() + "`. Replacing the `aws.auth#sigv4` authentication scheme with the `aws.auth#sigv4a` authentication scheme directly may not be backward compatible if the signing scope was narrowed (typically from `*`)."));
        } else if (noSigV4XRemoved) {
            boolean isSigV4BeforeSigV4A;
            int oldSigV4Index = oldAuthSchemes.indexOf(SigV4Trait.ID);
            int oldSigV4aIndex = oldAuthSchemes.indexOf(SigV4ATrait.ID);
            int sigV4Index = newAuthSchemes.indexOf(SigV4Trait.ID);
            int sigV4aIndex = newAuthSchemes.indexOf(SigV4ATrait.ID);
            boolean isOldSigV4BeforeSigV4A = oldSigV4Index < oldSigV4aIndex;
            boolean bl2 = isSigV4BeforeSigV4A = sigV4Index < sigV4aIndex;
            if (isOldSigV4BeforeSigV4A && !isSigV4BeforeSigV4A) {
                events.add(this.danger(shape, "The `aws.auth#sigv4a` authentication scheme was moved before the `aws.auth#sigv4` authentication scheme in the effective auth schemes for `" + shape.getId() + "`. Moving the `aws.auth#sigv4a` authentication scheme before the `aws.auth#sigv4` authentication scheme is not backward compatible since not all credentials usable by `aws.auth#sigv4` are compatible with `aws.auth#sigv4a`, and can break existing clients' authentication."));
            }
            if (!isOldSigV4BeforeSigV4A && isSigV4BeforeSigV4A) {
                events.add(this.danger(shape, "The `aws.auth#sigv4` authentication scheme was moved before the `aws.auth#sigv4a` authentication scheme in the effective auth schemes for `" + shape.getId() + "`. Moving the `aws.auth#sigv4` authentication scheme before the `aws.auth#sigv4a` authentication scheme may not be backward compatible if the signing scope was narrowed (typically from `*`)."));
            }
        } else if (isSigV4Added) {
            int sigV4aIndex;
            boolean isSigV4AddedBeforeSigV4A;
            int sigV4Index = newAuthSchemes.indexOf(SigV4Trait.ID);
            boolean bl3 = isSigV4AddedBeforeSigV4A = sigV4Index < (sigV4aIndex = newAuthSchemes.indexOf(SigV4ATrait.ID));
            if (isSigV4AddedBeforeSigV4A) {
                events.add(this.danger(shape, "The `aws.auth#sigv4` authentication scheme was added before the `aws.auth#sigv4a` authentication scheme in the effective auth schemes for `" + shape.getId() + "`. Adding the `aws.auth#sigv4` authentication scheme before an existing `aws.auth#sigv4a` authentication scheme may not be backward compatible if the signing scope was narrowed (typically from `*`)."));
            }
        } else if (isSigV4AAdded) {
            boolean isSigV4AAddedBeforeSigV4;
            int sigV4Index = newAuthSchemes.indexOf(SigV4Trait.ID);
            int sigV4aIndex = newAuthSchemes.indexOf(SigV4ATrait.ID);
            boolean bl4 = isSigV4AAddedBeforeSigV4 = sigV4aIndex < sigV4Index;
            if (isSigV4AAddedBeforeSigV4) {
                events.add(this.danger(shape, "The `aws.auth#sigv4a` authentication scheme was added before the `aws.auth#sigv4` authentication scheme in the effective auth schemes for `" + shape.getId() + "`. Adding the `aws.auth#sigv4a` authentication scheme before an existing `aws.auth#sigv4` authentication scheme is not backward compatible since not all credentials usable by `aws.auth#sigv4` are compatible with `aws.auth#sigv4a`, and can break existing clients' authentication."));
            }
        }
    }

    private static Map<OperationShape, Set<ServiceShape>> computeOperationToContainedServiceBindings(Model model) {
        HashMap<OperationShape, Set<ServiceShape>> operationToContainedServiceBindings = new HashMap<OperationShape, Set<ServiceShape>>();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        for (OperationShape operationShape : model.getOperationShapes()) {
            Set operationEntry = operationToContainedServiceBindings.getOrDefault(operationShape, new HashSet());
            for (ServiceShape serviceShape : model.getServiceShapes()) {
                if (!topDownIndex.getContainedOperations((ToShapeId)serviceShape).contains(operationShape)) continue;
                operationEntry.add(serviceShape);
            }
            operationToContainedServiceBindings.put(operationShape, operationEntry);
        }
        return operationToContainedServiceBindings;
    }
}

