/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
public final class HttpChecksumTrait
extends AbstractTrait
implements ToSmithyBuilder<HttpChecksumTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.protocols#httpChecksum");
    public static final String CHECKSUM_PREFIX = "x-amz-checksum-";
    public static final List<String> CHECKSUM_ALGORITHMS = ListUtils.of((Object[])new String[]{"CRC64NVME", "CRC32C", "CRC32", "SHA1", "SHA256"});
    public static final List<String> VALIDATION_MODES = ListUtils.of((Object)"ENABLED");
    public static final String REQUEST_CHECKSUM_REQUIRED = "requestChecksumRequired";
    public static final String REQUEST_ALGORITHM_MEMBER = "requestAlgorithmMember";
    public static final String REQUEST_VALIDATION_MODE_MEMBER = "requestValidationModeMember";
    public static final String RESPONSE_ALGORITHMS = "responseAlgorithms";
    private final boolean requestChecksumRequired;
    private final String requestAlgorithmMember;
    private final String requestValidationModeMember;
    private final List<String> responseAlgorithms;

    private HttpChecksumTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.requestChecksumRequired = builder.requestChecksumRequired;
        this.requestAlgorithmMember = builder.requestAlgorithmMember;
        this.requestValidationModeMember = builder.requestValidationModeMember;
        this.responseAlgorithms = (List)builder.responseAlgorithms.copy();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)new Builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).requestChecksumRequired(this.requestChecksumRequired).requestAlgorithmMember(this.requestAlgorithmMember).requestValidationModeMember(this.requestValidationModeMember).responseAlgorithms(this.responseAlgorithms);
    }

    public boolean isRequestChecksumRequired() {
        return this.requestChecksumRequired;
    }

    public Optional<String> getRequestAlgorithmMember() {
        return Optional.ofNullable(this.requestAlgorithmMember);
    }

    public List<String> getResponseAlgorithms() {
        return this.responseAlgorithms;
    }

    public Optional<String> getRequestValidationModeMember() {
        return Optional.ofNullable(this.requestValidationModeMember);
    }

    public static String getChecksumLocationName(String checksumAlgorithm) {
        return CHECKSUM_PREFIX + checksumAlgorithm.toLowerCase(Locale.US);
    }

    protected Node createNode() {
        ObjectNode.Builder builder = ObjectNode.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withOptionalMember(REQUEST_ALGORITHM_MEMBER, this.getRequestAlgorithmMember().map(Node::from)).withOptionalMember(REQUEST_VALIDATION_MODE_MEMBER, this.getRequestValidationModeMember().map(Node::from));
        if (this.isRequestChecksumRequired()) {
            builder.withMember(REQUEST_CHECKSUM_REQUIRED, (ToNode)Node.from((boolean)true));
        }
        if (!this.getResponseAlgorithms().isEmpty()) {
            builder.withMember(RESPONSE_ALGORITHMS, (ToNode)Node.fromStrings(this.getResponseAlgorithms()));
        }
        return builder.build();
    }

    public static final class Builder
    extends AbstractTraitBuilder<HttpChecksumTrait, Builder> {
        private String requestAlgorithmMember;
        private boolean requestChecksumRequired;
        private String requestValidationModeMember;
        private final BuilderRef<List<String>> responseAlgorithms = BuilderRef.forList();

        private Builder() {
        }

        public HttpChecksumTrait build() {
            return new HttpChecksumTrait(this);
        }

        public Builder requestAlgorithmMember(String input) {
            this.requestAlgorithmMember = input;
            return this;
        }

        public Builder requestChecksumRequired(boolean isRequired) {
            this.requestChecksumRequired = isRequired;
            return this;
        }

        public Builder requestValidationModeMember(String input) {
            this.requestValidationModeMember = input;
            return this;
        }

        public Builder responseAlgorithms(List<String> algorithms) {
            this.responseAlgorithms.clear();
            ((List)this.responseAlgorithms.get()).addAll(algorithms);
            return this;
        }

        public Builder addResponseAlgorithm(String algorithm) {
            ((List)this.responseAlgorithms.get()).add(algorithm);
            return this;
        }

        public Builder clearResponseAlgorithms() {
            this.responseAlgorithms.clear();
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Builder builder = (Builder)HttpChecksumTrait.builder().sourceLocation((FromSourceLocation)value);
            builder.requestChecksumRequired(objectNode.getBooleanMemberOrDefault(HttpChecksumTrait.REQUEST_CHECKSUM_REQUIRED));
            objectNode.getStringMember(HttpChecksumTrait.REQUEST_ALGORITHM_MEMBER).map(StringNode::getValue).ifPresent(builder::requestAlgorithmMember);
            objectNode.getArrayMember(HttpChecksumTrait.RESPONSE_ALGORITHMS).ifPresent(responseAlgorithmNodes -> {
                for (String algorithm : responseAlgorithmNodes.getElementsAs(StringNode::getValue)) {
                    builder.addResponseAlgorithm(algorithm);
                }
            });
            objectNode.getStringMember(HttpChecksumTrait.REQUEST_VALIDATION_MODE_MEMBER).map(StringNode::getValue).ifPresent(builder::requestValidationModeMember);
            HttpChecksumTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

