/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.aws.traits.auth.SigV4ATrait;
import software.amazon.smithy.aws.traits.auth.SigV4Trait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class SigV4TraitsValidator
extends AbstractValidator {
    private static final ShapeId SERVICE_ARN_NAMESPACE = ServiceTrait.ID.withMember("arnNamespace");
    private static final ShapeId SIGV4_NAME = SigV4Trait.ID.withMember("name");
    private static final ShapeId SIGV4A_NAME = SigV4ATrait.ID.withMember("name");

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ServiceShape service : model.getServiceShapes()) {
            events.addAll(this.validateService(model, service));
        }
        return events;
    }

    private List<ValidationEvent> validateService(Model model, ServiceShape service) {
        String sigv4Name;
        String sigv4aName;
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Optional serviceTraitOptional = service.getTrait(ServiceTrait.class);
        Optional sigv4TraitOptional = service.getTrait(SigV4Trait.class);
        Optional sigv4aTraitOptional = service.getTrait(SigV4ATrait.class);
        if (serviceTraitOptional.isPresent()) {
            String sigv4Name2;
            String serviceArnNamespace = ((ServiceTrait)((Object)serviceTraitOptional.get())).getArnNamespace();
            if (sigv4TraitOptional.isPresent() && !serviceArnNamespace.equals(sigv4Name2 = ((SigV4Trait)((Object)sigv4TraitOptional.get())).getName())) {
                events.add(this.createValuesShouldMatchWarning(service, SERVICE_ARN_NAMESPACE, serviceArnNamespace, SIGV4_NAME, sigv4Name2));
            }
            if (sigv4aTraitOptional.isPresent() && !serviceArnNamespace.equals(sigv4aName = ((SigV4ATrait)((Object)sigv4aTraitOptional.get())).getName())) {
                events.add(this.createValuesShouldMatchWarning(service, SERVICE_ARN_NAMESPACE, serviceArnNamespace, SIGV4A_NAME, sigv4aName));
            }
        }
        if (sigv4TraitOptional.isPresent() && sigv4aTraitOptional.isPresent() && !(sigv4Name = ((SigV4Trait)((Object)sigv4TraitOptional.get())).getName()).equals(sigv4aName = ((SigV4ATrait)((Object)sigv4aTraitOptional.get())).getName())) {
            events.add(this.createValuesShouldMatchWarning(service, SIGV4_NAME, sigv4Name, SIGV4A_NAME, sigv4aName));
        }
        return events;
    }

    private ValidationEvent createValuesShouldMatchWarning(ServiceShape service, ShapeId member1, String value1, ShapeId member2, String value2) {
        return this.warning((Shape)service, String.format("Value for `%s` \"%s\" and value for `%s` \"%s\" SHOULD match.", member1.toString(), value1, member2.toString(), value2));
    }
}

