/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.clientendpointdiscovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientDiscoveredEndpointTrait;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryIdTrait;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryInfo;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;

public final class ClientEndpointDiscoveryIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Map<ShapeId, ClientEndpointDiscoveryInfo>> endpointDiscoveryInfo = new HashMap<ShapeId, Map<ShapeId, ClientEndpointDiscoveryInfo>>();

    public ClientEndpointDiscoveryIndex(Model model) {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        OperationIndex opIndex = OperationIndex.of((Model)model);
        for (ServiceShape service : model.getServiceShapesWithTrait(ClientEndpointDiscoveryTrait.class)) {
            Map<ShapeId, ClientEndpointDiscoveryInfo> serviceInfo;
            ClientEndpointDiscoveryTrait trait = (ClientEndpointDiscoveryTrait)service.expectTrait(ClientEndpointDiscoveryTrait.class);
            ShapeId endpointOperationId = trait.getOperation();
            Optional<ShapeId> endpointErrorId = trait.getOptionalError();
            Optional endpointOperation = model.getShape(endpointOperationId).flatMap(Shape::asOperationShape);
            Optional endpointError = endpointErrorId.flatMap(arg_0 -> ((Model)model).getShape(arg_0)).flatMap(Shape::asStructureShape);
            if (!endpointOperation.isPresent() || (serviceInfo = this.getOperations(service, (OperationShape)endpointOperation.get(), endpointError.orElse(null), topDownIndex, opIndex)).isEmpty()) continue;
            this.endpointDiscoveryInfo.put(service.getId(), serviceInfo);
        }
    }

    public static ClientEndpointDiscoveryIndex of(Model model) {
        return (ClientEndpointDiscoveryIndex)model.getKnowledge(ClientEndpointDiscoveryIndex.class, ClientEndpointDiscoveryIndex::new);
    }

    private Map<ShapeId, ClientEndpointDiscoveryInfo> getOperations(ServiceShape service, OperationShape endpointOperation, StructureShape endpointError, TopDownIndex topDownIndex, OperationIndex opIndex) {
        HashMap<ShapeId, ClientEndpointDiscoveryInfo> result = new HashMap<ShapeId, ClientEndpointDiscoveryInfo>();
        for (OperationShape operation : topDownIndex.getContainedOperations((ToShapeId)service)) {
            operation.getTrait(ClientDiscoveredEndpointTrait.class).ifPresent(trait -> {
                List<MemberShape> discoveryIds = this.getDiscoveryIds(opIndex, operation);
                ClientEndpointDiscoveryInfo info = new ClientEndpointDiscoveryInfo(service, operation, endpointOperation, endpointError, discoveryIds, trait.isRequired());
                result.put(operation.getId(), info);
            });
        }
        return result;
    }

    private List<MemberShape> getDiscoveryIds(OperationIndex opIndex, OperationShape operation) {
        ArrayList<MemberShape> discoveryIds = new ArrayList<MemberShape>();
        for (MemberShape member : opIndex.expectInputShape((ToShapeId)operation).getAllMembers().values()) {
            if (!member.hasTrait(ClientEndpointDiscoveryIdTrait.class)) continue;
            discoveryIds.add(member);
        }
        return discoveryIds;
    }

    public Optional<ClientEndpointDiscoveryInfo> getEndpointDiscoveryInfo(ToShapeId service, ToShapeId operation) {
        return Optional.ofNullable(this.endpointDiscoveryInfo.get(service.toShapeId())).flatMap(mappings -> Optional.ofNullable((ClientEndpointDiscoveryInfo)mappings.get(operation.toShapeId())));
    }

    public Set<ShapeId> getEndpointDiscoveryOperations(ToShapeId service) {
        return Optional.ofNullable(this.endpointDiscoveryInfo.get(service.toShapeId())).flatMap(mappings -> Optional.of(mappings.keySet())).orElse(new HashSet());
    }
}

