/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import software.amazon.smithy.aws.traits.ArnTrait;
import software.amazon.smithy.aws.traits.tagging.AwsTagIndex;
import software.amazon.smithy.aws.traits.tagging.TagEnabledTrait;
import software.amazon.smithy.aws.traits.tagging.TaggableApiConfig;
import software.amazon.smithy.aws.traits.tagging.TaggableTrait;
import software.amazon.smithy.aws.traits.tagging.TaggingShapeUtils;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.PropertyBindingIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TaggableResourceValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        LinkedList<ValidationEvent> events = new LinkedList<ValidationEvent>();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        AwsTagIndex tagIndex = AwsTagIndex.of(model);
        PropertyBindingIndex propertyBindingIndex = PropertyBindingIndex.of((Model)model);
        for (ServiceShape service : model.getServiceShapesWithTrait(TagEnabledTrait.class)) {
            for (ResourceShape resource : topDownIndex.getContainedResources((ToShapeId)service)) {
                if (resource.hasTrait(TaggableTrait.class)) {
                    events.addAll(this.validateResource(model, resource, service, tagIndex, propertyBindingIndex));
                    continue;
                }
                if (!resource.hasTrait(ArnTrait.class) || !tagIndex.serviceHasTagApis(service.getId())) continue;
                events.add(this.warning((Shape)resource, "Resource is likely missing `aws.api#taggable` trait."));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateResource(Model model, ResourceShape resource, ServiceShape service, AwsTagIndex awsTagIndex, PropertyBindingIndex propertyBindingIndex) {
        LinkedList<ValidationEvent> events = new LinkedList<ValidationEvent>();
        if (awsTagIndex.isResourceTagOnUpdate(resource.getId())) {
            Shape updateOperation = model.expectShape((ShapeId)resource.getUpdate().get());
            events.add(this.danger(updateOperation, "Update resource lifecycle operation should not support updating tags because it is a privileged operation that modifies access."));
        }
        boolean isServiceWideTaggable = awsTagIndex.serviceHasTagApis(service.getId());
        boolean isInstanceOpTaggable = this.isTaggableViaInstanceOperations(events, model, resource, service, propertyBindingIndex);
        if (isServiceWideTaggable && !isInstanceOpTaggable && !resource.hasTrait(ArnTrait.class)) {
            events.add(this.error((Shape)resource, "Resource is taggable only via service-wide tag operations. It must use the `aws.api@arn` trait."));
        }
        if (!isServiceWideTaggable && !isInstanceOpTaggable) {
            events.add(this.error((Shape)resource, "Resource does not have tagging CRUD operations and is not compatible with service-wide tagging operations."));
        }
        return events;
    }

    private Optional<OperationShape> resolveTagOperation(ShapeId tagApiId, Model model) {
        return model.getShape(tagApiId).flatMap(shape -> shape.asOperationShape());
    }

    private boolean isTaggableViaInstanceOperations(List<ValidationEvent> events, Model model, ResourceShape resource, ServiceShape service, PropertyBindingIndex propertyBindingIndex) {
        TaggableTrait taggableTrait = (TaggableTrait)resource.expectTrait(TaggableTrait.class);
        if (taggableTrait.getApiConfig().isPresent()) {
            Optional<OperationShape> listTagsApi;
            Optional<OperationShape> untagApi;
            TaggableApiConfig apiConfig = taggableTrait.getApiConfig().get();
            boolean tagApiVerified = false;
            boolean untagApiVerified = false;
            boolean listTagsApiVerified = false;
            Optional<OperationShape> tagApi = this.resolveTagOperation(apiConfig.getTagApi(), model);
            if (tagApi.isPresent()) {
                boolean bl = tagApiVerified = TaggingShapeUtils.isTagPropertyInInput(Optional.of(tagApi.get().getId()), model, resource, propertyBindingIndex) && this.verifyTagApi(tagApi.get(), model, service, resource);
            }
            if ((untagApi = this.resolveTagOperation(apiConfig.getUntagApi(), model)).isPresent()) {
                untagApiVerified = this.verifyUntagApi(untagApi.get(), model, service, resource);
            }
            if ((listTagsApi = this.resolveTagOperation(apiConfig.getListTagsApi(), model)).isPresent()) {
                listTagsApiVerified = this.verifyListTagsApi(listTagsApi.get(), model, service, resource);
            }
            return tagApiVerified && untagApiVerified && listTagsApiVerified;
        }
        return false;
    }

    private boolean verifyListTagsApi(OperationShape listTagsApi, Model model, ServiceShape service, ResourceShape resource) {
        return this.exactlyOne(this.collectMemberTargetShapes(listTagsApi.getOutputShape(), model), memberEntry -> TaggingShapeUtils.isTagDesiredName(((MemberShape)memberEntry.getKey()).getMemberName()) && TaggingShapeUtils.verifyTagsShape(model, (Shape)memberEntry.getValue()));
    }

    private boolean verifyUntagApi(OperationShape untagApi, Model model, ServiceShape service, ResourceShape resource) {
        return this.exactlyOne(this.collectMemberTargetShapes(untagApi.getInputShape(), model), memberEntry -> TaggingShapeUtils.isTagKeysDesiredName(((MemberShape)memberEntry.getKey()).getMemberName()) && TaggingShapeUtils.verifyTagKeysShape(model, (Shape)memberEntry.getValue()));
    }

    private boolean verifyTagApi(OperationShape tagApi, Model model, ServiceShape service, ResourceShape resource) {
        return this.exactlyOne(this.collectMemberTargetShapes(tagApi.getInputShape(), model), memberEntry -> TaggingShapeUtils.isTagDesiredName(((MemberShape)memberEntry.getKey()).getMemberName()) && TaggingShapeUtils.verifyTagsShape(model, (Shape)memberEntry.getValue()));
    }

    private boolean exactlyOne(Collection<Map.Entry<MemberShape, Shape>> collection, Predicate<Map.Entry<MemberShape, Shape>> test) {
        int count = 0;
        for (Map.Entry<MemberShape, Shape> entry : collection) {
            if (!test.test(entry)) continue;
            ++count;
        }
        return count == 1;
    }

    private Collection<Map.Entry<MemberShape, Shape>> collectMemberTargetShapes(ShapeId ioShapeId, Model model) {
        LinkedList<Map.Entry<MemberShape, Shape>> collection = new LinkedList<Map.Entry<MemberShape, Shape>>();
        for (MemberShape memberShape : model.expectShape(ioShapeId).members()) {
            collection.add(new AbstractMap.SimpleImmutableEntry<MemberShape, Shape>(memberShape, model.expectShape(memberShape.getTarget())));
        }
        return collection;
    }
}

