/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TaggableApiConfig
implements FromSourceLocation,
ToNode,
ToSmithyBuilder<TaggableApiConfig> {
    private final ShapeId tagApi;
    private final ShapeId untagApi;
    private final ShapeId listTagsApi;
    private final SourceLocation sourceLocation;

    private TaggableApiConfig(Builder builder) {
        this.tagApi = builder.tagApi;
        this.untagApi = builder.untagApi;
        this.listTagsApi = builder.listTagsApi;
        this.sourceLocation = Objects.requireNonNull(builder.sourceLocation);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ShapeId getTagApi() {
        return this.tagApi;
    }

    public ShapeId getUntagApi() {
        return this.untagApi;
    }

    public ShapeId getListTagsApi() {
        return this.listTagsApi;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public Builder toBuilder() {
        Builder builder = TaggableApiConfig.builder();
        return builder.tagApi(this.tagApi).untagApi(this.untagApi).listTagsApi(this.listTagsApi).sourceLocation(this.sourceLocation);
    }

    public Node toNode() {
        return Node.objectNodeBuilder().sourceLocation(this.getSourceLocation()).withMember("tagApi", this.tagApi.toString()).withMember("untagApi", this.untagApi.toString()).withMember("listTagsApi", this.listTagsApi.toString()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaggableApiConfig)) {
            return false;
        }
        TaggableApiConfig other = (TaggableApiConfig)o;
        return this.toNode().equals(other.toNode());
    }

    public int hashCode() {
        return this.toNode().hashCode();
    }

    public static final class Builder
    implements SmithyBuilder<TaggableApiConfig> {
        private ShapeId tagApi;
        private ShapeId untagApi;
        private ShapeId listTagsApi;
        private SourceLocation sourceLocation = SourceLocation.none();

        Builder tagApi(ShapeId tagApi) {
            this.tagApi = tagApi;
            return this;
        }

        Builder untagApi(ShapeId untagApi) {
            this.untagApi = untagApi;
            return this;
        }

        Builder listTagsApi(ShapeId listTagsApi) {
            this.listTagsApi = listTagsApi;
            return this;
        }

        Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public TaggableApiConfig build() {
            return new TaggableApiConfig(this);
        }
    }
}

