/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.traits.tagging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.aws.traits.tagging.TaggableTrait;
import software.amazon.smithy.aws.traits.tagging.TaggingShapeUtils;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TagResourcePropertyTypeValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ResourceShape resource : model.getResourceShapesWithTrait(TaggableTrait.class)) {
            Shape propertyShape;
            ShapeId propertyShapeId;
            TaggableTrait trait = (TaggableTrait)resource.expectTrait(TaggableTrait.class);
            Map properties = resource.getProperties();
            if (!trait.getProperty().isPresent() || (propertyShapeId = (ShapeId)properties.get(trait.getProperty().get())) == null || TaggingShapeUtils.verifyTagsShape(model, propertyShape = model.expectShape(propertyShapeId))) continue;
            events.add(this.error((Shape)resource, "Tag property must be a list shape targeting a member containing a pair of strings, or a Map shape targeting a string member."));
        }
        return events;
    }
}

