// This file defines test cases that test HTTP response code bindings.
// See: https://awslabs.github.io/smithy/1.0/spec/core/http-traits.html#httpresponsecode-trait

$version: "1.0"

namespace aws.protocoltests.restjson

use aws.protocols#restJson1
use smithy.test#httpResponseTests

@idempotent
@http(uri: "/HttpResponseCode", method: "PUT")
operation HttpResponseCode {
    output: HttpResponseCodeOutput
}

structure HttpResponseCodeOutput {
    @httpResponseCode
    Status: Integer
}

apply HttpResponseCode @httpResponseTests([
    {
        id: "RestJsonHttpResponseCode",
        documentation: "Binds the http response code to an output structure.",
        protocol: restJson1,
        code: 201,
        headers: {
            "Content-Type": "application/json"
        },
        "body": "",
        "bodyMediaType": "json",
        params: {
            Status: 201,
        }
    }
])
