/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.aws.iam.traits.ConditionKeysIndex;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.StringListTrait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ServiceResolvedConditionKeysTrait
extends StringListTrait
implements ToSmithyBuilder<ServiceResolvedConditionKeysTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.iam#serviceResolvedConditionKeys");
    private List<String> resolvedConditionKeys;

    public ServiceResolvedConditionKeysTrait(List<String> conditionKeys) {
        super(ID, conditionKeys, (FromSourceLocation)SourceLocation.NONE);
    }

    public ServiceResolvedConditionKeysTrait(List<String> conditionKeys, FromSourceLocation sourceLocation) {
        super(ID, conditionKeys, sourceLocation);
    }

    public List<String> resolveConditionKeys(ServiceShape service) {
        if (this.resolvedConditionKeys == null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String value : this.getValues()) {
                keys.add(ConditionKeysIndex.resolveFullConditionKey(service, value));
            }
            this.resolvedConditionKeys = ListUtils.copyOf(keys);
        }
        return this.resolvedConditionKeys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return (Builder)((Builder)ServiceResolvedConditionKeysTrait.builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).values(this.getValues());
    }

    public static final class Builder
    extends StringListTrait.Builder<ServiceResolvedConditionKeysTrait, Builder> {
        public ServiceResolvedConditionKeysTrait build() {
            return new ServiceResolvedConditionKeysTrait(this.getValues(), (FromSourceLocation)this.getSourceLocation());
        }
    }

    public static final class Provider
    extends StringListTrait.Provider<ServiceResolvedConditionKeysTrait> {
        public Provider() {
            super(ID, ServiceResolvedConditionKeysTrait::new);
        }
    }
}

