/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.iam.traits.IamResourceTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class IamResourceTraitConflictingNameValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        return model.shapes(ServiceShape.class).flatMap(shape -> this.validateService(topDownIndex, (ServiceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(TopDownIndex topDownIndex, ServiceShape service) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        HashMap<String, List> resourceMap = new HashMap<String, List>();
        for (ResourceShape resource : topDownIndex.getContainedResources((ToShapeId)service)) {
            String resourceName = IamResourceTrait.resolveResourceName(resource).toLowerCase(Locale.US);
            resourceMap.computeIfAbsent(resourceName, k -> new ArrayList()).add(resource.getId());
        }
        resourceMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.error((Shape)service, String.format("Multiple IAM resources defined with the same IAM resource name is not allowed in a service closure, but found multiple resources case-insensitively named `%s` in the service `%s`: [%s]", entry.getKey(), service.getId(), ValidationUtils.tickedList((Collection)((Collection)entry.getValue()))))).forEach(events::add);
        return events;
    }
}

