/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.aws.iam.traits.ConditionKeyValueTrait;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public class ConditionKeyValueTraitValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (!model.getAppliedTraits().contains(ConditionKeyValueTrait.ID)) {
            return events;
        }
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        for (ServiceShape service : model.getServiceShapesWithTrait(ServiceTrait.class)) {
            for (OperationShape operation : topDownIndex.getContainedOperations((ToShapeId)service)) {
                HashMap<String, List> conditionKeyMembers = new HashMap<String, List>();
                for (MemberShape memberShape : operationIndex.getInputMembers((ToShapeId)operation).values()) {
                    if (!memberShape.hasTrait(ConditionKeyValueTrait.ID)) continue;
                    ConditionKeyValueTrait trait = (ConditionKeyValueTrait)memberShape.expectTrait(ConditionKeyValueTrait.class);
                    String conditionKey = trait.resolveConditionKey(service);
                    conditionKeyMembers.computeIfAbsent(conditionKey, k -> new ArrayList()).add(memberShape.getMemberName());
                }
                for (Map.Entry entry : conditionKeyMembers.entrySet()) {
                    if (((List)entry.getValue()).size() <= 1) continue;
                    events.add(this.error((Shape)operationIndex.expectInputShape((ToShapeId)operation), String.format("The `%s` condition key has its value supplied in the `%s` operation's input shape by multiple members [%s]. This value must only be supplied by one member.", entry.getKey(), operation.getId(), ValidationUtils.tickedList((Collection)((Collection)entry.getValue())))));
                }
            }
        }
        return events;
    }
}

