/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ActionResource
implements ToNode,
ToSmithyBuilder<ActionResource> {
    private static final String CONDITION_KEYS = "conditionKeys";
    private final List<String> conditionKeys;

    private ActionResource(Builder builder) {
        this.conditionKeys = (List)builder.conditionKeys.copy();
    }

    public List<String> getConditionKeys() {
        return this.conditionKeys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ActionResource fromNode(Node value) {
        Builder builder = ActionResource.builder();
        value.expectObjectNode().warnIfAdditionalProperties(Collections.singletonList(CONDITION_KEYS)).getArrayMember(CONDITION_KEYS, StringNode::getValue, builder::conditionKeys);
        return builder.build();
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder();
        if (!this.conditionKeys.isEmpty()) {
            builder.withMember(CONDITION_KEYS, (ToNode)ArrayNode.fromStrings(this.conditionKeys));
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return ActionResource.builder().conditionKeys(this.conditionKeys);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionResource that = (ActionResource)o;
        return Objects.equals(this.conditionKeys, that.conditionKeys);
    }

    public int hashCode() {
        return Objects.hash(this.conditionKeys);
    }

    public static final class Builder
    implements SmithyBuilder<ActionResource> {
        private final BuilderRef<List<String>> conditionKeys = BuilderRef.forList();

        public ActionResource build() {
            return new ActionResource(this);
        }

        public Builder conditionKeys(List<String> conditionKeys) {
            this.clearConditionKeys();
            ((List)this.conditionKeys.get()).addAll(conditionKeys);
            return this;
        }

        public Builder clearConditionKeys() {
            ((List)this.conditionKeys.get()).clear();
            return this;
        }

        public Builder addConditionKey(String conditionKey) {
            ((List)this.conditionKeys.get()).add(conditionKey);
            return this;
        }

        public Builder removeConditionKey(String conditionKey) {
            ((List)this.conditionKeys.get()).remove(conditionKey);
            return this;
        }
    }
}

