/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ConditionKeyDefinition
implements ToNode,
ToSmithyBuilder<ConditionKeyDefinition> {
    private static final String TYPE = "type";
    private static final String DOCUMENTATION = "documentation";
    private static final String EXTERNAL_DOCUMENTATION = "externalDocumentation";
    private static final String RELATIVE_DOCUMENTATION = "relativeDocumentation";
    private final String type;
    private final String documentation;
    private final String externalDocumentation;
    private final String relativeDocumentation;

    private ConditionKeyDefinition(Builder builder) {
        this.type = (String)SmithyBuilder.requiredState((String)TYPE, (Object)builder.type);
        this.documentation = builder.documentation;
        this.externalDocumentation = builder.externalDocumentation;
        this.relativeDocumentation = builder.relativeDocumentation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ConditionKeyDefinition fromNode(Node value) {
        ObjectNode objectNode = value.expectObjectNode();
        Builder builder = ConditionKeyDefinition.builder().type(objectNode.expectStringMember(TYPE).getValue());
        objectNode.getStringMember(DOCUMENTATION).map(StringNode::getValue).ifPresent(builder::documentation);
        objectNode.getStringMember(EXTERNAL_DOCUMENTATION).map(StringNode::getValue).ifPresent(builder::externalDocumentation);
        objectNode.getStringMember(RELATIVE_DOCUMENTATION).map(StringNode::getValue).ifPresent(builder::relativeDocumentation);
        return builder.build();
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public Optional<String> getExternalDocumentation() {
        return Optional.ofNullable(this.externalDocumentation);
    }

    public Optional<String> getRelativeDocumentation() {
        return Optional.ofNullable(this.relativeDocumentation);
    }

    public SmithyBuilder<ConditionKeyDefinition> toBuilder() {
        return ConditionKeyDefinition.builder().documentation(this.documentation).externalDocumentation(this.externalDocumentation).relativeDocumentation(this.relativeDocumentation).type(this.type);
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withMember(TYPE, (ToNode)Node.from((String)this.type)).withOptionalMember(DOCUMENTATION, this.getDocumentation().map(Node::from)).withOptionalMember(EXTERNAL_DOCUMENTATION, this.getExternalDocumentation().map(Node::from)).withOptionalMember(RELATIVE_DOCUMENTATION, this.getRelativeDocumentation().map(Node::from)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionKeyDefinition that = (ConditionKeyDefinition)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.documentation, that.documentation) && Objects.equals(this.externalDocumentation, that.externalDocumentation) && Objects.equals(this.relativeDocumentation, that.relativeDocumentation);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.documentation, this.externalDocumentation, this.relativeDocumentation);
    }

    public static final class Builder
    implements SmithyBuilder<ConditionKeyDefinition> {
        private String type;
        private String documentation;
        private String externalDocumentation;
        private String relativeDocumentation;

        public ConditionKeyDefinition build() {
            return new ConditionKeyDefinition(this);
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder externalDocumentation(String externalDocumentation) {
            this.externalDocumentation = externalDocumentation;
            return this;
        }

        public Builder relativeDocumentation(String relativeDocumentation) {
            this.relativeDocumentation = relativeDocumentation;
            return this;
        }
    }
}

