/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.aws.iam.traits.ActionNameTrait;
import software.amazon.smithy.aws.iam.traits.ActionPermissionDescriptionTrait;
import software.amazon.smithy.aws.iam.traits.IamActionTrait;
import software.amazon.smithy.aws.iam.traits.RequiredActionsTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class IamActionValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : model.getOperationShapesWithTrait(IamActionTrait.class)) {
            IamActionTrait trait = (IamActionTrait)operation.expectTrait(IamActionTrait.class);
            events.addAll(this.validateDuplicateTraits(operation, trait));
            this.validateUniqueResourceNames(operation, trait).ifPresent(events::add);
        }
        return events;
    }

    private List<ValidationEvent> validateDuplicateTraits(OperationShape operation, IamActionTrait trait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (operation.hasTrait(ActionNameTrait.ID) && trait.getName().isPresent()) {
            events.add(this.emitDeprecatedOverride(operation, operation.expectTrait(ActionNameTrait.class), "name"));
        }
        if (operation.hasTrait(ActionPermissionDescriptionTrait.ID) && trait.getDocumentation().isPresent()) {
            events.add(this.emitDeprecatedOverride(operation, operation.expectTrait(ActionPermissionDescriptionTrait.class), "documentation"));
        }
        if (operation.hasTrait(RequiredActionsTrait.ID) && !trait.getRequiredActions().isEmpty()) {
            events.add(this.emitDeprecatedOverride(operation, operation.expectTrait(RequiredActionsTrait.class), "requiredActions"));
        }
        return events;
    }

    private ValidationEvent emitDeprecatedOverride(OperationShape operation, Trait trait, String name) {
        return this.error((Shape)operation, (FromSourceLocation)trait, String.format("Operation has the `%s` property of the `@aws.iam#iamAction` trait set and the deprecated `@%s` trait applied.", name, trait.toShapeId()), "ConflictingProperty", name);
    }

    private Optional<ValidationEvent> validateUniqueResourceNames(OperationShape operation, IamActionTrait trait) {
        if (!trait.getResources().isPresent() || trait.getResources().get().getRequired().isEmpty() || trait.getResources().get().getOptional().isEmpty()) {
            return Optional.empty();
        }
        LinkedHashSet<String> duplicateNames = new LinkedHashSet<String>(trait.getResources().get().getRequired().keySet());
        duplicateNames.retainAll(trait.getResources().get().getOptional().keySet());
        if (duplicateNames.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.danger((Shape)operation, (FromSourceLocation)trait, "Operation has the following resource names defined as both required and optional: " + duplicateNames, "Resources", "DuplicateEntries"));
    }
}

