/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class IamResourceTrait
extends AbstractTrait
implements ToSmithyBuilder<IamResourceTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.iam#iamResource");
    public final String name;

    private IamResourceTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.name = builder.name;
    }

    public Optional<String> getName() {
        return Optional.of(this.name);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Node createNode() {
        NodeMapper mapper = new NodeMapper();
        mapper.disableToNodeForClass(IamResourceTrait.class);
        mapper.setOmitEmptyValues(true);
        return mapper.serialize((Object)this).expectObjectNode();
    }

    public SmithyBuilder<IamResourceTrait> toBuilder() {
        return ((Builder)IamResourceTrait.builder().sourceLocation((FromSourceLocation)this.getSourceLocation())).name(this.name);
    }

    public static final class Builder
    extends AbstractTraitBuilder<IamResourceTrait, Builder> {
        private String name;

        private Builder() {
        }

        public IamResourceTrait build() {
            return new IamResourceTrait(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            IamResourceTrait result = (IamResourceTrait)((Object)new NodeMapper().deserialize(value, IamResourceTrait.class));
            result.setNodeCache(value);
            return result;
        }
    }
}

