/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.aws.iam.traits.ConditionKeyValueTrait;
import software.amazon.smithy.aws.iam.traits.ConditionKeysIndex;
import software.amazon.smithy.aws.iam.traits.ServiceResolvedConditionKeysTrait;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class ConditionKeysValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ConditionKeysIndex conditionIndex = ConditionKeysIndex.of(model);
        TopDownIndex topDownIndex = TopDownIndex.of((Model)model);
        OperationIndex operationIndex = OperationIndex.of((Model)model);
        return model.shapes(ServiceShape.class).filter(service -> service.hasTrait(ServiceTrait.class)).flatMap(service -> {
            ArrayList<ValidationEvent> results = new ArrayList<ValidationEvent>();
            Set<String> knownKeys = conditionIndex.getDefinedConditionKeys((ToShapeId)service).keySet();
            Set serviceResolvedKeys = Collections.emptySet();
            if (service.hasTrait(ServiceResolvedConditionKeysTrait.class)) {
                ServiceResolvedConditionKeysTrait trait = (ServiceResolvedConditionKeysTrait)service.expectTrait(ServiceResolvedConditionKeysTrait.class);
                serviceResolvedKeys = new HashSet(trait.getValues());
                ArrayList invalidNames = new ArrayList(trait.getValues());
                invalidNames.removeAll(knownKeys);
                if (!invalidNames.isEmpty()) {
                    results.add(this.error((Shape)service, (FromSourceLocation)trait, String.format("This condition keys resolved by the `%s` service refer to undefined condition key(s) [%s]. Expected one of the following defined condition keys: [%s]", service.getId(), ValidationUtils.tickedList(invalidNames), ValidationUtils.tickedList(knownKeys))));
                }
            }
            for (OperationShape operation : topDownIndex.getContainedOperations((ToShapeId)service)) {
                for (String name : conditionIndex.getConditionKeyNames((ToShapeId)service, (ToShapeId)operation)) {
                    if (knownKeys.contains(name) || name.startsWith("aws:")) continue;
                    results.add(this.error((Shape)operation, String.format("This operation scoped within the `%s` service refers to an undefined condition key `%s`. Expected one of the following defined condition keys: [%s]", service.getId(), name, ValidationUtils.tickedList(knownKeys))));
                }
                for (MemberShape memberShape : operationIndex.getInputMembers((ToShapeId)operation).values()) {
                    if (!memberShape.hasTrait(ConditionKeyValueTrait.class)) continue;
                    ConditionKeyValueTrait trait = (ConditionKeyValueTrait)memberShape.expectTrait(ConditionKeyValueTrait.class);
                    String conditionKey = trait.getValue();
                    if (!knownKeys.contains(conditionKey)) {
                        results.add(this.error((Shape)memberShape, (FromSourceLocation)trait, String.format("This operation `%s` scoped within the `%s` service with member `%s` refers to an undefined condition key `%s`. Expected one of the following defined condition keys: [%s]", operation.getId(), service.getId(), memberShape.getId(), conditionKey, ValidationUtils.tickedList(knownKeys))));
                    }
                    if (!serviceResolvedKeys.contains(conditionKey)) continue;
                    results.add(this.error((Shape)memberShape, (FromSourceLocation)trait, String.format("This operation `%s` scoped within the `%s` service with member `%s` refers to a condition key `%s` that is also resolved by service.", operation.getId(), service.getId(), memberShape.getId(), conditionKey, ValidationUtils.tickedList(knownKeys))));
                }
            }
            return results.stream();
        }).collect(Collectors.toList());
    }
}

