/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.aws.iam.traits.ConditionKeyDefinition;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class DefineConditionKeysTrait
extends AbstractTrait
implements ToSmithyBuilder<DefineConditionKeysTrait> {
    public static final ShapeId ID = ShapeId.from((String)"aws.iam#defineConditionKeys");
    private final Map<String, ConditionKeyDefinition> conditionKeys;

    private DefineConditionKeysTrait(Builder builder) {
        super(ID, (FromSourceLocation)builder.getSourceLocation());
        this.conditionKeys = MapUtils.copyOf((Map)builder.conditionKeys);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, ConditionKeyDefinition> getConditionKeys() {
        return this.conditionKeys;
    }

    public Optional<ConditionKeyDefinition> getConditionKey(String name) {
        return Optional.ofNullable(this.conditionKeys.get(name));
    }

    protected Node createNode() {
        return ((ObjectNode)this.conditionKeys.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<StringNode, Node>(Node.from((String)((String)entry.getKey())), ((ConditionKeyDefinition)entry.getValue()).toNode())).collect(ObjectNode.collect(Map.Entry::getKey, Map.Entry::getValue))).toBuilder().sourceLocation(this.getSourceLocation()).build();
    }

    public Builder toBuilder() {
        Builder builder = (Builder)DefineConditionKeysTrait.builder().sourceLocation((FromSourceLocation)this.getSourceLocation());
        this.conditionKeys.forEach(builder::putConditionKey);
        return builder;
    }

    public static final class Builder
    extends AbstractTraitBuilder<DefineConditionKeysTrait, Builder> {
        private final Map<String, ConditionKeyDefinition> conditionKeys = new HashMap<String, ConditionKeyDefinition>();

        private Builder() {
        }

        public DefineConditionKeysTrait build() {
            return new DefineConditionKeysTrait(this);
        }

        public Builder putConditionKey(String name, ConditionKeyDefinition definition) {
            this.conditionKeys.put(name, definition);
            return this;
        }

        public Builder removeConditionKey(String name) {
            this.conditionKeys.remove(name);
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)DefineConditionKeysTrait.builder().sourceLocation((FromSourceLocation)value);
            for (Map.Entry entry : value.expectObjectNode().getMembers().entrySet()) {
                ConditionKeyDefinition definition = ConditionKeyDefinition.fromNode((Node)((Node)entry.getValue()).expectObjectNode());
                builder.putConditionKey(((StringNode)entry.getKey()).getValue(), definition);
            }
            DefineConditionKeysTrait result = builder.build();
            result.setNodeCache(value);
            return result;
        }
    }
}

