/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.aws.iam.traits;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.aws.iam.traits.ConditionKeyDefinition;
import software.amazon.smithy.aws.iam.traits.ConditionKeysTrait;
import software.amazon.smithy.aws.iam.traits.DefineConditionKeysTrait;
import software.amazon.smithy.aws.iam.traits.DisableConditionKeyInferenceTrait;
import software.amazon.smithy.aws.traits.ArnReferenceTrait;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.StringUtils;

public final class ConditionKeysIndex
implements KnowledgeIndex {
    private static final String STRING_TYPE = "String";
    private static final String ARN_TYPE = "ARN";
    private final Map<ShapeId, Map<String, ConditionKeyDefinition>> serviceConditionKeys = new HashMap<ShapeId, Map<String, ConditionKeyDefinition>>();
    private final Map<ShapeId, Map<ShapeId, Set<String>>> resourceConditionKeys = new HashMap<ShapeId, Map<ShapeId, Set<String>>>();

    public ConditionKeysIndex(Model model) {
        model.shapes(ServiceShape.class).forEach(service -> service.getTrait(ServiceTrait.class).ifPresent(trait -> {
            this.serviceConditionKeys.put(service.getId(), new HashMap(service.getTrait(DefineConditionKeysTrait.class).map(DefineConditionKeysTrait::getConditionKeys).orElse(MapUtils.of())));
            this.resourceConditionKeys.put(service.getId(), new HashMap());
            String arnRoot = trait.getArnNamespace();
            service.getResources().stream().flatMap(id -> OptionalUtils.stream((Optional)model.getShape(id))).forEach(resource -> this.compute(model, service.getId(), arnRoot, (Shape)resource, null));
            service.getOperations().stream().flatMap(id -> OptionalUtils.stream((Optional)model.getShape(id))).forEach(operation -> this.compute(model, service.getId(), arnRoot, (Shape)operation, null));
        }));
    }

    public Map<String, ConditionKeyDefinition> getDefinedConditionKeys(ToShapeId service) {
        return Collections.unmodifiableMap(this.serviceConditionKeys.getOrDefault(service.toShapeId(), MapUtils.of()));
    }

    public Set<String> getConditionKeyNames(ToShapeId service) {
        return (Set)this.resourceConditionKeys.getOrDefault(service.toShapeId(), MapUtils.of()).values().stream().flatMap(Collection::stream).collect(SetUtils.toUnmodifiableSet());
    }

    public Set<String> getConditionKeyNames(ToShapeId service, ToShapeId resourceOrOperation) {
        ShapeId serviceId = service.toShapeId();
        ShapeId subjectId = resourceOrOperation.toShapeId();
        return Collections.unmodifiableSet(this.resourceConditionKeys.getOrDefault(serviceId, MapUtils.of()).getOrDefault(subjectId, SetUtils.of()));
    }

    public Map<String, ConditionKeyDefinition> getDefinedConditionKeys(ToShapeId service, ToShapeId resourceOrOperation) {
        Map<String, ConditionKeyDefinition> serviceDefinitions = this.getDefinedConditionKeys(service);
        HashMap<String, ConditionKeyDefinition> definitions = new HashMap<String, ConditionKeyDefinition>();
        for (String name : this.getConditionKeyNames(service, resourceOrOperation)) {
            if (!serviceDefinitions.containsKey(name)) continue;
            definitions.put(name, serviceDefinitions.get(name));
        }
        return definitions;
    }

    private void compute(Model model, ShapeId service, String arnRoot, Shape subject, ResourceShape parent) {
        this.compute(model, service, arnRoot, subject, parent, SetUtils.of());
    }

    private void compute(Model model, ShapeId service, String arnRoot, Shape subject, ResourceShape parent, Set<String> parentDefinitions) {
        HashSet<String> definitions = new HashSet<String>(parentDefinitions);
        this.resourceConditionKeys.get(service).put(subject.getId(), definitions);
        subject.getTrait(ConditionKeysTrait.class).ifPresent(trait -> definitions.addAll(trait.getValues()));
        subject.asResourceShape().ifPresent(resource -> {
            Map<String, String> childIdentifiers = !resource.hasTrait(DisableConditionKeyInferenceTrait.class) ? this.inferChildResourceIdentifiers(model, service, arnRoot, (ResourceShape)resource, parent) : MapUtils.of();
            resource.getAllOperations().stream().flatMap(id -> OptionalUtils.stream((Optional)model.getShape(id))).forEach(child -> this.compute(model, service, arnRoot, (Shape)child, (ResourceShape)resource));
            definitions.addAll(childIdentifiers.values());
            resource.getResources().stream().flatMap(id -> OptionalUtils.stream((Optional)model.getShape(id))).forEach(child -> this.compute(model, service, arnRoot, (Shape)child, (ResourceShape)resource, (Set<String>)definitions));
        });
    }

    private Map<String, String> inferChildResourceIdentifiers(Model model, ShapeId service, String arnRoot, ResourceShape resource, ResourceShape parent) {
        HashMap<String, String> result = new HashMap<String, String>();
        Set parentIds = parent == null ? SetUtils.of() : parent.getIdentifiers().keySet();
        HashSet childIds = new HashSet(resource.getIdentifiers().keySet());
        childIds.removeAll(parentIds);
        for (String childId : childIds) {
            model.getShape((ShapeId)resource.getIdentifiers().get(childId)).ifPresent(shape -> {
                ConditionKeyDefinition.Builder builder = ConditionKeyDefinition.builder();
                if (shape.hasTrait(ArnReferenceTrait.class)) {
                    builder.type(ARN_TYPE);
                } else {
                    builder.type(STRING_TYPE);
                }
                builder.documentation(shape.getTrait(DocumentationTrait.class).map(StringTrait::getValue).orElse(ConditionKeysIndex.computeIdentifierDocs(resource.getId(), childId)));
                String computeIdentifierName = ConditionKeysIndex.computeIdentifierName(arnRoot, resource, childId);
                result.put(childId, computeIdentifierName);
                this.serviceConditionKeys.get(service).put(computeIdentifierName, builder.build());
            });
        }
        return result;
    }

    private static String computeIdentifierDocs(ShapeId id, String identifierName) {
        return id.getName() + " resource " + identifierName + " identifier";
    }

    private static String computeIdentifierName(String arnRoot, ResourceShape resource, String identifierName) {
        return arnRoot + ":" + resource.getId().getName() + StringUtils.capitalize((String)identifierName);
    }
}

